/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.plugins.ec2.Messages;
import hudson.util.EnumConverter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.apache.commons.beanutils.Converter;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.Stapler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AwsRegion {
    US_EAST_1(Messages._AwsRegion_UsEast()),
    US_WEST_1(Messages._AwsRegion_UsWest()),
    EU_WEST_1(Messages._AwsRegion_EuWest());

    public final URL ec2Endpoint;
    public final URL s3Endpoint;
    public final Localizable displayName;

    private AwsRegion(Localizable displayName) {
        try {
            String host = this.name().toLowerCase(Locale.ENGLISH).replace('_', '-');
            this.ec2Endpoint = new URL("https://" + host + ".ec2.amazonaws.com/");
            this.s3Endpoint = new URL("https://" + host + ".s3.amazonaws.com/");
            this.displayName = displayName;
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    public String toString() {
        return this.displayName.toString();
    }

    static {
        Stapler.CONVERT_UTILS.register((Converter)new EnumConverter(), AwsRegion.class);
    }
}

