/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.Launcher;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.User;
import hudson.plugins.emailext.EmailExtException;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.scm.ChangeLogSet;
import hudson.tasks.Mailer;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedEmailPublisher
extends Publisher {
    private static final Logger LOGGER = Logger.getLogger(Mailer.class.getName());
    public static final String EMAIL_ADDRESS_REGEXP = "^.*<([^>]+)>.*$";
    public static final String COMMA_SEPARATED_SPLIT_REGEXP = "[,\\s]+";
    private static final String DEFAULT_BODY = "\\$DEFAULT_CONTENT";
    private static final String DEFAULT_SUBJECT = "\\$DEFAULT_SUBJECT";
    private static final String PROJECT_DEFAULT_BODY = "\\$PROJECT_DEFAULT_CONTENT";
    private static final String PROJECT_DEFAULT_SUBJECT = "\\$PROJECT_DEFAULT_SUBJECT";
    private static final Map<String, EmailContent> EMAIL_CONTENT_TYPE_MAP = new HashMap();
    private static final Map<String, EmailTriggerDescriptor> EMAIL_TRIGGER_TYPE_MAP = new HashMap();
    public static final String OLD_DEFAULT_SUBJECT_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
    public static final String OLD_DEFAULT_BODY_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $HUDSON_URL/$BUILD_URL to view the results.";
    public static final String DEFAULT_SUBJECT_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
    public static final String DEFAULT_BODY_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results.";
    public static final String PROJECT_DEFAULT_SUBJECT_TEXT = "$PROJECT_DEFAULT_SUBJECT";
    public static final String PROJECT_DEFAULT_BODY_TEXT = "$PROJECT_DEFAULT_CONTENT";
    public String recipientList;
    private List<EmailTrigger> configuredTriggers = new ArrayList();
    public String defaultSubject;
    public String defaultContent;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public static void addEmailContentType(EmailContent contentType) throws EmailExtException {
        if (EMAIL_CONTENT_TYPE_MAP.containsKey(contentType.getToken())) {
            throw new EmailExtException("An email content type with token= " + contentType.getToken() + " has already been added.");
        }
        EMAIL_CONTENT_TYPE_MAP.put(contentType.getToken(), contentType);
    }

    public static void removeEmailContentType(EmailContent contentType) {
        if (EMAIL_CONTENT_TYPE_MAP.containsKey(contentType.getToken())) {
            EMAIL_CONTENT_TYPE_MAP.remove(contentType);
        }
    }

    public static void addEmailTriggerType(EmailTriggerDescriptor triggerType) throws EmailExtException {
        if (EMAIL_TRIGGER_TYPE_MAP.containsKey(triggerType.getMailerId())) {
            throw new EmailExtException("An email trigger type with name= " + triggerType.getTriggerName() + " has already been added.");
        }
        EMAIL_TRIGGER_TYPE_MAP.put(triggerType.getMailerId(), triggerType);
    }

    public static void removeEmailTriggerType(EmailTriggerDescriptor triggerType) {
        if (EMAIL_TRIGGER_TYPE_MAP.containsKey(triggerType.getMailerId())) {
            EMAIL_TRIGGER_TYPE_MAP.remove(triggerType.getMailerId());
        }
    }

    public static Collection<EmailTriggerDescriptor> getEmailTriggers() {
        return EMAIL_TRIGGER_TYPE_MAP.values();
    }

    public static Collection<String> getEmailTriggerNames() {
        return EMAIL_TRIGGER_TYPE_MAP.keySet();
    }

    public static List<EmailTrigger> getTriggersForNonConfiguredInstance() {
        ArrayList<EmailTrigger> retList = new ArrayList<EmailTrigger>();
        for (String triggerName : EMAIL_TRIGGER_TYPE_MAP.keySet()) {
            retList.add(((EmailTriggerDescriptor)EMAIL_TRIGGER_TYPE_MAP.get(triggerName)).getNewInstance(null));
        }
        return retList;
    }

    public static Collection<EmailContent> getEmailContentTypes() {
        return EMAIL_CONTENT_TYPE_MAP.values();
    }

    public List<EmailTrigger> getConfiguredTriggers() {
        if (this.configuredTriggers == null) {
            this.configuredTriggers = new ArrayList();
        }
        return this.configuredTriggers;
    }

    public List<EmailTrigger> getNonConfiguredTriggers() {
        List confTriggers = this.getConfiguredTriggers();
        ArrayList<EmailTrigger> retList = new ArrayList<EmailTrigger>();
        for (String triggerName : EMAIL_TRIGGER_TYPE_MAP.keySet()) {
            boolean contains = false;
            for (EmailTrigger trigger : confTriggers) {
                if (!trigger.getDescriptor().getTriggerName().equals(triggerName)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            retList.add(((EmailTriggerDescriptor)EMAIL_TRIGGER_TYPE_MAP.get(triggerName)).getNewInstance(null));
        }
        return retList;
    }

    public boolean isConfigured() {
        return !this.getConfiguredTriggers().isEmpty();
    }

    public boolean getConfigured() {
        return this.isConfigured();
    }

    public boolean perform(Build build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this._perform(build, launcher, listener);
    }

    public <P extends Project<P, B>, B extends Build<P, B>> boolean _perform(B build, Launcher launcher, BuildListener listener) throws InterruptedException {
        boolean emailTriggered = false;
        HashMap<String, EmailTrigger> triggered = new HashMap<String, EmailTrigger>();
        for (EmailTrigger trigger : this.configuredTriggers) {
            if (!trigger.trigger(build)) continue;
            String tName = trigger.getDescriptor().getTriggerName();
            triggered.put(tName, trigger);
            listener.getLogger().println("Email was triggered for: " + tName);
            emailTriggered = true;
        }
        ArrayList replacedTriggers = new ArrayList();
        for (String triggerName : triggered.keySet()) {
            replacedTriggers.addAll(((EmailTrigger)triggered.get(triggerName)).getDescriptor().getTriggerReplaceList());
        }
        for (String triggerName : replacedTriggers) {
            triggered.remove(triggerName);
            listener.getLogger().println("Trigger " + triggerName + " was overridden by another trigger and will not send an email.");
        }
        if (emailTriggered && triggered.isEmpty()) {
            listener.getLogger().println("There is a circular trigger replacement with the email triggers.  No email is sent.");
            return false;
        }
        if (triggered.isEmpty()) {
            listener.getLogger().println("No emails were triggered.");
            return true;
        }
        listener.getLogger().println("There are " + triggered.size() + " triggered emails.");
        for (String triggerName : triggered.keySet()) {
            listener.getLogger().println("Sending email for trigger: " + triggerName);
            this.sendMail(((EmailTrigger)triggered.get(triggerName)).getEmail(), build, listener);
        }
        return true;
    }

    private <P extends Project<P, B>, B extends Build<P, B>> boolean sendMail(EmailType mailType, B build, BuildListener listener) {
        try {
            MimeMessage msg = this.createMail(mailType, build, listener);
            Address[] allRecipients = msg.getAllRecipients();
            if (allRecipients != null) {
                StringBuffer buf = new StringBuffer("Sending e-mails to:");
                for (Address a : allRecipients) {
                    buf.append(' ').append(a);
                }
                listener.getLogger().println(buf);
                Transport.send((Message)msg);
                return true;
            }
            listener.getLogger().println("An attempt to send an e-mail to empty list of recipients, ignored.");
        }
        catch (MessagingException e) {
            LOGGER.log(Level.WARNING, "Could not send email.", e);
            listener.getLogger().println("Could not send email as a part of the post-build publishers.");
        }
        return false;
    }

    private <P extends Project<P, B>, B extends Build<P, B>> MimeMessage createMail(EmailType type, B build, BuildListener listener) throws MessagingException {
        int i;
        MimeMessage msg = new MimeMessage(DESCRIPTOR.createSession());
        msg.setContent((Object)"", "text/plain");
        msg.setFrom((Address)new InternetAddress(DESCRIPTOR.getAdminAddress()));
        msg.setSentDate(new Date());
        String subject = this.transformText(type, type.getSubject(), build);
        msg.setSubject(subject);
        String text = this.transformText(type, type.getBody(), build);
        msg.setText(text);
        ArrayList<InternetAddress> rcp = new ArrayList<InternetAddress>();
        if (type.getSendToRecipientList()) {
            String[] recipients = this.recipientList.split(COMMA_SEPARATED_SPLIT_REGEXP);
            for (i = 0; i < recipients.length; ++i) {
                rcp.add(new InternetAddress(recipients[i]));
            }
        }
        if (type.getSendToDevelopers()) {
            HashSet<User> users = new HashSet<User>();
            for (ChangeLogSet.Entry change : build.getChangeSet()) {
                User a = change.getAuthor();
                if (!users.add(a)) continue;
                String adrs = ((Mailer.UserProperty)a.getProperty(Mailer.UserProperty.class)).getAddress();
                if (adrs != null) {
                    rcp.add(new InternetAddress(adrs));
                    continue;
                }
                listener.getLogger().println("Failed to send e-mail to " + a.getFullName() + " because no e-mail address is known, and no default e-mail domain is configured");
            }
        }
        if (type.getRecipientList() != null && type.getRecipientList().trim().length() > 0) {
            String[] typeRecipients = type.getRecipientList().split(COMMA_SEPARATED_SPLIT_REGEXP);
            for (i = 0; i < typeRecipients.length; ++i) {
                rcp.add(new InternetAddress(typeRecipients[i]));
            }
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])rcp.toArray(new InternetAddress[rcp.size()]));
        return msg;
    }

    private <P extends Project<P, B>, B extends Build<P, B>> String transformText(EmailType type, String origText, B build) {
        String newText = origText.replaceAll(PROJECT_DEFAULT_BODY, Matcher.quoteReplacement(this.defaultContent)).replaceAll(PROJECT_DEFAULT_SUBJECT, Matcher.quoteReplacement(this.defaultSubject)).replaceAll(DEFAULT_BODY, Matcher.quoteReplacement(DESCRIPTOR.getDefaultBody())).replaceAll(DEFAULT_SUBJECT, Matcher.quoteReplacement(DESCRIPTOR.getDefaultSubject()));
        newText = this.replaceTokensWithContent(newText, type, build);
        return newText;
    }

    public <P extends Project<P, B>, B extends Build<P, B>> String replaceTokensWithContent(String origText, EmailType type, Build<P, B> build) {
        StringBuffer sb = new StringBuffer();
        String[] tokens = origText.split("\\$");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            String[] tokenParts = token.split("[^a-zA-Z0-9_]");
            String tokenPart = tokenParts[0];
            String nonTokenPart = token.substring(tokenPart.length());
            EmailContent content = (EmailContent)EMAIL_CONTENT_TYPE_MAP.get(tokenPart);
            if (content != null) {
                String contentText = content.getContent(build, type);
                if (content.hasNestedContent()) {
                    String replacedNestedText = this.replaceTokensWithContent(contentText, type, build);
                    sb.append(replacedNestedText);
                } else {
                    sb.append(contentText);
                }
                sb.append(nonTokenPart);
                continue;
            }
            if (token == null || token.length() <= 0) continue;
            sb.append(token);
        }
        return sb.toString();
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    static /* synthetic */ List access$002(ExtendedEmailPublisher x0, List x1) {
        x0.configuredTriggers = x1;
        return x0.configuredTriggers;
    }

    static /* synthetic */ Map access$100() {
        return EMAIL_TRIGGER_TYPE_MAP;
    }

    static /* synthetic */ List access$000(ExtendedEmailPublisher x0) {
        return x0.configuredTriggers;
    }
}

