/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import hudson.model.Build;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedTrigger
extends EmailTrigger {
    public static final String TRIGGER_NAME = "Fixed";
    public static DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @Override
    public <P extends Project<P, B>, B extends Build<P, B>> boolean trigger(B build) {
        Build prevBuild;
        Result buildResult = build.getResult();
        return buildResult == Result.SUCCESS && (prevBuild = (Build)build.getPreviousBuild()) != null && (prevBuild.getResult() == Result.UNSTABLE || prevBuild.getResult() == Result.FAILURE);
    }

    @Override
    public EmailTriggerDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public boolean getDefaultSendToDevs() {
        return true;
    }

    @Override
    public boolean getDefaultSendToList() {
        return true;
    }

    public static final class DescriptorImpl
    extends EmailTriggerDescriptor {
        public DescriptorImpl() {
            this.addTriggerNameToReplace("Success");
        }

        public String getTriggerName() {
            return FixedTrigger.TRIGGER_NAME;
        }

        public EmailTrigger newInstance() {
            return new FixedTrigger();
        }

        public String getHelpText() {
            return "An email will be sent when the build status changes from Failure or Unstable to Successful.";
        }
    }
}

