/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import hudson.model.Build;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuccessTrigger
extends EmailTrigger {
    public static final String TRIGGER_NAME = "Success";
    public static DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @Override
    public <P extends Project<P, B>, B extends Build<P, B>> boolean trigger(B build) {
        Result buildResult = build.getResult();
        return buildResult == Result.SUCCESS;
    }

    @Override
    public EmailTriggerDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public boolean getDefaultSendToDevs() {
        return true;
    }

    @Override
    public boolean getDefaultSendToList() {
        return false;
    }

    public static final class DescriptorImpl
    extends EmailTriggerDescriptor {
        public String getTriggerName() {
            return SuccessTrigger.TRIGGER_NAME;
        }

        public EmailTrigger newInstance() {
            return new SuccessTrigger();
        }

        public String getHelpText() {
            return "An email will be sent if the build status is \"Successful\". If the \"Fixed\" trigger is configured, and the previous build status was \"Failure\" or \"Unstable\", then a the \"Fixed\" trigger will send an email instead.";
        }
    }
}

