/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import hudson.model.Build;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnstableTrigger
extends EmailTrigger {
    public static final String TRIGGER_NAME = "Unstable";
    public static DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @Override
    public <P extends Project<P, B>, B extends Build<P, B>> boolean trigger(B build) {
        Result buildResult = build.getResult();
        return buildResult == Result.UNSTABLE;
    }

    @Override
    public EmailTriggerDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public boolean getDefaultSendToDevs() {
        return true;
    }

    @Override
    public boolean getDefaultSendToList() {
        return true;
    }

    public static final class DescriptorImpl
    extends EmailTriggerDescriptor {
        public String getTriggerName() {
            return UnstableTrigger.TRIGGER_NAME;
        }

        public EmailTrigger newInstance() {
            return new UnstableTrigger();
        }

        public String getHelpText() {
            return "An email will be sent any time the build is unstable.  If the \"Still Unstable\" trigger is configured, then a unstable email will not be sent if multiple buildsare unstable without a successful build.";
        }
    }
}

