/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.plugins.EmailContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildStatusContent
implements EmailContent {
    private static final String TOKEN = "BUILD_STATUS";

    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, EmailType emailType) {
        Result buildResult = build.getResult();
        if (buildResult == Result.FAILURE) {
            AbstractBuild prevBuild = (AbstractBuild)build.getPreviousBuild();
            if (prevBuild != null && prevBuild.getResult() == Result.FAILURE) {
                return "Still Failing";
            }
            return "Failure";
        }
        if (buildResult == Result.UNSTABLE) {
            AbstractBuild prevBuild = (AbstractBuild)build.getPreviousBuild();
            if (prevBuild != null && prevBuild.getResult() == Result.UNSTABLE) {
                return "Still Unstable";
            }
            return "Unstable";
        }
        if (buildResult == Result.SUCCESS) {
            AbstractBuild prevBuild = (AbstractBuild)build.getPreviousBuild();
            if (prevBuild != null && (prevBuild.getResult() == Result.UNSTABLE || prevBuild.getResult() == Result.FAILURE)) {
                return "Fixed";
            }
            return "Successful";
        }
        return "Unknown";
    }

    public String getToken() {
        return TOKEN;
    }

    public boolean hasNestedContent() {
        return false;
    }

    public String getHelpText() {
        return "Displays the status of the current build. (failing, success, etc...)";
    }
}

