/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.Plugin;
import hudson.plugins.emailext.EmailExtException;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.content.BuildNumberContent;
import hudson.plugins.emailext.plugins.content.BuildStatusContent;
import hudson.plugins.emailext.plugins.content.BuildURLContent;
import hudson.plugins.emailext.plugins.content.ChangesSinceLastBuildContent;
import hudson.plugins.emailext.plugins.content.ChangesSinceLastSuccessfulBuildContent;
import hudson.plugins.emailext.plugins.content.HudsonURLContent;
import hudson.plugins.emailext.plugins.content.ProjectNameContent;
import hudson.plugins.emailext.plugins.content.ProjectURLContent;
import hudson.plugins.emailext.plugins.trigger.FailureTrigger;
import hudson.plugins.emailext.plugins.trigger.FixedTrigger;
import hudson.plugins.emailext.plugins.trigger.StillFailingTrigger;
import hudson.plugins.emailext.plugins.trigger.StillUnstableTrigger;
import hudson.plugins.emailext.plugins.trigger.SuccessTrigger;
import hudson.plugins.emailext.plugins.trigger.UnstableTrigger;
import hudson.tasks.BuildStep;

public class EmailExtensionPlugin
extends Plugin {
    public void start() throws Exception {
        BuildStep.PUBLISHERS.add((Object)ExtendedEmailPublisher.DESCRIPTOR);
        this.addEmailContentPlugin(new BuildNumberContent());
        this.addEmailContentPlugin(new BuildStatusContent());
        this.addEmailContentPlugin(new BuildURLContent());
        this.addEmailContentPlugin(new ChangesSinceLastBuildContent());
        this.addEmailContentPlugin(new ChangesSinceLastSuccessfulBuildContent());
        this.addEmailContentPlugin(new HudsonURLContent());
        this.addEmailContentPlugin(new ProjectNameContent());
        this.addEmailContentPlugin(new ProjectURLContent());
        this.addEmailTriggerPlugin(FailureTrigger.DESCRIPTOR);
        this.addEmailTriggerPlugin(StillFailingTrigger.DESCRIPTOR);
        this.addEmailTriggerPlugin(UnstableTrigger.DESCRIPTOR);
        this.addEmailTriggerPlugin(StillUnstableTrigger.DESCRIPTOR);
        this.addEmailTriggerPlugin(SuccessTrigger.DESCRIPTOR);
        this.addEmailTriggerPlugin(FixedTrigger.DESCRIPTOR);
    }

    private void addEmailContentPlugin(EmailContent content) {
        try {
            ExtendedEmailPublisher.addEmailContentType(content);
        }
        catch (EmailExtException e) {
            System.out.println("Content type " + content + " was already added.");
        }
    }

    private void addEmailTriggerPlugin(EmailTriggerDescriptor trigger) {
        try {
            ExtendedEmailPublisher.addEmailTriggerType(trigger);
        }
        catch (EmailExtException e) {
            System.out.println("Trigger type " + trigger.getTriggerName() + " was already added.");
        }
    }
}

