/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailContent;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceFileContent
implements EmailContent {
    public static final String VAR_PATH_NAME = "path";

    public String getToken() {
        return "FILE";
    }

    public List<String> getArguments() {
        return Collections.singletonList(VAR_PATH_NAME);
    }

    public String getHelpText() {
        return "Includes the content of a specified file.\n<ul>\n<li><i>path</i> - The path to the file. Relative to the workspace root.\n</ul>\n";
    }

    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType emailType, Map<String, ?> args) throws IOException, InterruptedException {
        String path = EmailContent.Args.get(args, (String)VAR_PATH_NAME, null);
        if (path == null) {
            throw new IllegalArgumentException("FILE token requires the path parameter");
        }
        try {
            return build.getWorkspace().child(path).readToString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean hasNestedContent() {
        return false;
    }
}

