/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.emailext.EmailRecepientUtils;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedEmailPublisherDescriptor
extends BuildStepDescriptor<Publisher> {
    private String defaultSuffix;
    private String hudsonUrl;
    private String smtpAuthUsername;
    private Secret smtpAuthPassword;
    private String adminAddress;
    private String smtpHost;
    private boolean useSsl;
    private String smtpPort;
    private String defaultContentType;
    private String defaultSubject;
    private String defaultBody;
    private boolean overrideGlobalSettings;

    public String getDisplayName() {
        return "Editable Email Notification";
    }

    public String getAdminAddress() {
        String v = this.adminAddress;
        if (v == null) {
            v = "address not configured yet <nobody>";
        }
        return v;
    }

    public String getDefaultSuffix() {
        return this.defaultSuffix;
    }

    public Session createSession() {
        Properties props = new Properties(System.getProperties());
        if (this.smtpHost != null) {
            props.put("mail.smtp.host", this.smtpHost);
        }
        if (this.smtpPort != null) {
            props.put("mail.smtp.port", this.smtpPort);
        }
        if (this.useSsl) {
            if (props.getProperty("mail.smtp.socketFactory.port") == null) {
                String port = this.smtpPort == null ? "465" : this.smtpPort;
                props.put("mail.smtp.port", port);
                props.put("mail.smtp.socketFactory.port", port);
            }
            if (props.getProperty("mail.smtp.socketFactory.class") == null) {
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            props.put("mail.smtp.socketFactory.fallback", "false");
        }
        if (this.smtpAuthUsername != null) {
            props.put("mail.smtp.auth", "true");
        }
        return Session.getInstance((Properties)props, (Authenticator)this.getAuthenticator());
    }

    private Authenticator getAuthenticator() {
        String un = this.getSmtpAuthUsername();
        if (un == null) {
            return null;
        }
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(ExtendedEmailPublisherDescriptor.this.getSmtpAuthUsername(), ExtendedEmailPublisherDescriptor.this.getSmtpAuthPassword());
            }
        };
    }

    public String getHudsonUrl() {
        return this.hudsonUrl;
    }

    public String getSmtpServer() {
        return this.smtpHost;
    }

    public String getSmtpAuthUsername() {
        return this.smtpAuthUsername;
    }

    public String getSmtpAuthPassword() {
        return Secret.toString((Secret)this.smtpAuthPassword);
    }

    public boolean getUseSsl() {
        return this.useSsl;
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    public String getDefaultSubject() {
        return this.defaultSubject;
    }

    public String getDefaultBody() {
        return this.defaultBody;
    }

    public boolean getOverrideGlobalSettings() {
        return this.overrideGlobalSettings;
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        String listRecipients = formData.getString("recipientlist_recipients");
        ExtendedEmailPublisher m = new ExtendedEmailPublisher();
        m.recipientList = listRecipients;
        m.contentType = formData.getString("project_content_type");
        m.defaultSubject = formData.getString("project_default_subject");
        m.defaultContent = formData.getString("project_default_content");
        m.configuredTriggers = new ArrayList<EmailTrigger>();
        for (String mailerId : ExtendedEmailPublisher.EMAIL_TRIGGER_TYPE_MAP.keySet()) {
            if (!"true".equalsIgnoreCase(formData.optString("mailer_" + mailerId + "_configured"))) continue;
            EmailType type = this.createMailType(formData, mailerId);
            EmailTrigger trigger = ExtendedEmailPublisher.EMAIL_TRIGGER_TYPE_MAP.get(mailerId).getNewInstance(type);
            m.configuredTriggers.add(trigger);
        }
        return m;
    }

    private EmailType createMailType(JSONObject formData, String mailType) {
        EmailType m = new EmailType();
        String prefix = "mailer_" + mailType + '_';
        m.setSubject(formData.getString(prefix + "subject"));
        m.setBody(formData.getString(prefix + "body"));
        m.setRecipientList(formData.getString(prefix + "recipientList"));
        m.setSendToRecipientList(formData.optBoolean(prefix + "sendToRecipientList"));
        m.setSendToDevelopers(formData.optBoolean(prefix + "sendToDevelopers"));
        m.setIncludeCulprits(formData.optBoolean(prefix + "includeCulprits"));
        return m;
    }

    public ExtendedEmailPublisherDescriptor() {
        super(ExtendedEmailPublisher.class);
        this.load();
        if (this.defaultBody == null && this.defaultSubject == null) {
            this.defaultBody = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results.";
            this.defaultSubject = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
        }
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.smtpHost = this.nullify(req.getParameter("ext_mailer_smtp_server"));
        this.adminAddress = req.getParameter("ext_mailer_admin_address");
        this.defaultSuffix = this.nullify(req.getParameter("ext_mailer_default_suffix"));
        String url = this.nullify(req.getParameter("ext_mailer_hudson_url"));
        if (url != null && !url.endsWith("/")) {
            url = url + '/';
        }
        if (url == null) {
            url = Hudson.getInstance().getRootUrl();
        }
        this.hudsonUrl = url;
        if (req.getParameter("extmailer.useSMTPAuth") != null) {
            this.smtpAuthUsername = this.nullify(req.getParameter("extmailer.SMTPAuth.userName"));
            this.smtpAuthPassword = Secret.fromString((String)this.nullify(req.getParameter("extmailer.SMTPAuth.password")));
        } else {
            this.smtpAuthUsername = null;
            this.smtpAuthPassword = null;
        }
        this.useSsl = req.getParameter("ext_mailer_smtp_use_ssl") != null;
        this.smtpPort = this.nullify(req.getParameter("ext_mailer_smtp_port"));
        this.defaultContentType = this.nullify(req.getParameter("ext_mailer_default_content_type"));
        this.defaultSubject = this.nullify(req.getParameter("ext_mailer_default_subject"));
        this.defaultBody = this.nullify(req.getParameter("ext_mailer_default_body"));
        this.overrideGlobalSettings = req.getParameter("ext_mailer_override_global_settings") != null;
        this.save();
        return super.configure(req, formData);
    }

    private String nullify(String v) {
        if (v != null && v.length() == 0) {
            v = null;
        }
        return v;
    }

    public String getHelpFile() {
        return "/plugin/email-ext/help/main.html";
    }

    public FormValidation doAddressCheck(@QueryParameter String value) throws IOException, ServletException {
        try {
            new InternetAddress(value);
            return FormValidation.ok();
        }
        catch (AddressException e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    public FormValidation doRecipientListRecipientsCheck(@QueryParameter String value) throws IOException, ServletException {
        return new EmailRecepientUtils().validateFormRecipientList(value);
    }
}

