/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.emailext.EmailExtException;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.scm.ChangeLogSet;
import hudson.tasks.Mailer;
import hudson.tasks.Publisher;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedEmailPublisher
extends Publisher {
    private static final Logger LOGGER = Logger.getLogger(Mailer.class.getName());
    public static final String EMAIL_ADDRESS_REGEXP = "^.*<([^>]+)>.*$";
    public static final String COMMA_SEPARATED_SPLIT_REGEXP = "[,\\s]+";
    private static final String DEFAULT_BODY = "\\$DEFAULT_CONTENT";
    private static final String DEFAULT_SUBJECT = "\\$DEFAULT_SUBJECT";
    private static final String PROJECT_DEFAULT_BODY = "\\$PROJECT_DEFAULT_CONTENT";
    private static final String PROJECT_DEFAULT_SUBJECT = "\\$PROJECT_DEFAULT_SUBJECT";
    private static final Map<String, EmailContent> EMAIL_CONTENT_TYPE_MAP = new HashMap<String, EmailContent>();
    private static final Map<String, EmailTriggerDescriptor> EMAIL_TRIGGER_TYPE_MAP = new HashMap<String, EmailTriggerDescriptor>();
    public static final String OLD_DEFAULT_SUBJECT_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
    public static final String OLD_DEFAULT_BODY_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $HUDSON_URL/$BUILD_URL to view the results.";
    public static final String DEFAULT_SUBJECT_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
    public static final String DEFAULT_BODY_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results.";
    public static final String PROJECT_DEFAULT_SUBJECT_TEXT = "$PROJECT_DEFAULT_SUBJECT";
    public static final String PROJECT_DEFAULT_BODY_TEXT = "$PROJECT_DEFAULT_CONTENT";
    public String recipientList;
    private List<EmailTrigger> configuredTriggers = new ArrayList<EmailTrigger>();
    public String defaultSubject;
    public String defaultContent;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public static void addEmailContentType(EmailContent contentType) throws EmailExtException {
        if (EMAIL_CONTENT_TYPE_MAP.containsKey(contentType.getToken())) {
            throw new EmailExtException("An email content type with token= " + contentType.getToken() + " has already been added.");
        }
        EMAIL_CONTENT_TYPE_MAP.put(contentType.getToken(), contentType);
    }

    public static void removeEmailContentType(EmailContent contentType) {
        if (EMAIL_CONTENT_TYPE_MAP.containsKey(contentType.getToken())) {
            EMAIL_CONTENT_TYPE_MAP.remove(contentType);
        }
    }

    public static EmailContent getEmailContentType(String token) {
        return EMAIL_CONTENT_TYPE_MAP.get(token);
    }

    public static void addEmailTriggerType(EmailTriggerDescriptor triggerType) throws EmailExtException {
        if (EMAIL_TRIGGER_TYPE_MAP.containsKey(triggerType.getMailerId())) {
            throw new EmailExtException("An email trigger type with name= " + triggerType.getTriggerName() + " has already been added.");
        }
        EMAIL_TRIGGER_TYPE_MAP.put(triggerType.getMailerId(), triggerType);
    }

    public static void removeEmailTriggerType(EmailTriggerDescriptor triggerType) {
        if (EMAIL_TRIGGER_TYPE_MAP.containsKey(triggerType.getMailerId())) {
            EMAIL_TRIGGER_TYPE_MAP.remove(triggerType.getMailerId());
        }
    }

    public static EmailTriggerDescriptor getEmailTriggerType(String mailerId) {
        return EMAIL_TRIGGER_TYPE_MAP.get(mailerId);
    }

    public static Collection<EmailTriggerDescriptor> getEmailTriggers() {
        return EMAIL_TRIGGER_TYPE_MAP.values();
    }

    public static Collection<String> getEmailTriggerNames() {
        return EMAIL_TRIGGER_TYPE_MAP.keySet();
    }

    public static List<EmailTrigger> getTriggersForNonConfiguredInstance() {
        ArrayList<EmailTrigger> retList = new ArrayList<EmailTrigger>();
        for (String triggerName : EMAIL_TRIGGER_TYPE_MAP.keySet()) {
            retList.add(EMAIL_TRIGGER_TYPE_MAP.get(triggerName).getNewInstance(null));
        }
        return retList;
    }

    public static Collection<EmailContent> getEmailContentTypes() {
        return EMAIL_CONTENT_TYPE_MAP.values();
    }

    public List<EmailTrigger> getConfiguredTriggers() {
        if (this.configuredTriggers == null) {
            this.configuredTriggers = new ArrayList<EmailTrigger>();
        }
        return this.configuredTriggers;
    }

    public List<EmailTrigger> getNonConfiguredTriggers() {
        List<EmailTrigger> confTriggers = this.getConfiguredTriggers();
        ArrayList<EmailTrigger> retList = new ArrayList<EmailTrigger>();
        for (String triggerName : EMAIL_TRIGGER_TYPE_MAP.keySet()) {
            boolean contains = false;
            for (EmailTrigger trigger : confTriggers) {
                if (!trigger.getDescriptor().getTriggerName().equals(triggerName)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            retList.add(EMAIL_TRIGGER_TYPE_MAP.get(triggerName).getNewInstance(null));
        }
        return retList;
    }

    public boolean isConfigured() {
        return !this.getConfiguredTriggers().isEmpty();
    }

    public boolean getConfigured() {
        return this.isConfigured();
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this._perform(build, launcher, listener);
    }

    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> boolean _perform(B build, Launcher launcher, BuildListener listener) throws InterruptedException {
        boolean emailTriggered = false;
        HashMap<String, EmailTrigger> triggered = new HashMap<String, EmailTrigger>();
        for (EmailTrigger trigger : this.configuredTriggers) {
            if (!trigger.trigger(build)) continue;
            String tName = trigger.getDescriptor().getTriggerName();
            triggered.put(tName, trigger);
            listener.getLogger().println("Email was triggered for: " + tName);
            emailTriggered = true;
        }
        ArrayList<String> replacedTriggers = new ArrayList<String>();
        for (String triggerName : triggered.keySet()) {
            replacedTriggers.addAll(((EmailTrigger)triggered.get(triggerName)).getDescriptor().getTriggerReplaceList());
        }
        for (String triggerName : replacedTriggers) {
            triggered.remove(triggerName);
            listener.getLogger().println("Trigger " + triggerName + " was overridden by another trigger and will not send an email.");
        }
        if (emailTriggered && triggered.isEmpty()) {
            listener.getLogger().println("There is a circular trigger replacement with the email triggers.  No email is sent.");
            return false;
        }
        if (triggered.isEmpty()) {
            listener.getLogger().println("No emails were triggered.");
            return true;
        }
        listener.getLogger().println("There are " + triggered.size() + " triggered emails.");
        for (String triggerName : triggered.keySet()) {
            listener.getLogger().println("Sending email for trigger: " + triggerName);
            this.sendMail(((EmailTrigger)triggered.get(triggerName)).getEmail(), build, listener);
        }
        return true;
    }

    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> boolean sendMail(EmailType mailType, B build, BuildListener listener) {
        try {
            MimeMessage msg = this.createMail(mailType, build, listener);
            Address[] allRecipients = msg.getAllRecipients();
            if (allRecipients != null) {
                StringBuffer buf = new StringBuffer("Sending e-mails to:");
                for (Address a : allRecipients) {
                    buf.append(' ').append(a);
                }
                listener.getLogger().println(buf);
                Transport.send((Message)msg);
                return true;
            }
            listener.getLogger().println("An attempt to send an e-mail to empty list of recipients, ignored.");
        }
        catch (MessagingException e) {
            LOGGER.log(Level.WARNING, "Could not send email.", e);
            e.printStackTrace(listener.error("Could not send email as a part of the post-build publishers."));
        }
        return false;
    }

    private <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> MimeMessage createMail(EmailType type, B build, BuildListener listener) throws MessagingException {
        int i;
        MimeMessage msg = new MimeMessage(DESCRIPTOR.createSession());
        msg.setContent((Object)"", "text/plain");
        msg.setFrom((Address)new InternetAddress(DESCRIPTOR.getAdminAddress()));
        msg.setSentDate(new Date());
        String subject = this.transformText(type, type.getSubject(), build);
        msg.setSubject(subject);
        String text = this.transformText(type, type.getBody(), build);
        msg.setText(text);
        ArrayList<InternetAddress> rcp = new ArrayList<InternetAddress>();
        if (type.getSendToRecipientList()) {
            String[] recipients = this.recipientList.split(COMMA_SEPARATED_SPLIT_REGEXP);
            for (i = 0; i < recipients.length; ++i) {
                rcp.add(new InternetAddress(recipients[i]));
            }
        }
        if (type.getSendToDevelopers()) {
            HashSet<User> users;
            if (type.getIncludeCulprits()) {
                users = build.getCulprits();
            } else {
                users = new HashSet<User>();
                for (ChangeLogSet.Entry change : build.getChangeSet()) {
                    users.add(change.getAuthor());
                }
            }
            for (User user : users) {
                String adrs = ((Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)).getAddress();
                if (adrs != null) {
                    try {
                        rcp.add(new InternetAddress(adrs));
                    }
                    catch (AddressException ae) {
                        LOGGER.log(Level.WARNING, "Could not create email address.", ae);
                    }
                    continue;
                }
                listener.getLogger().println("Failed to send e-mail to " + user.getFullName() + " because no e-mail address is known, and no default e-mail domain is configured");
            }
        }
        if (type.getRecipientList() != null && type.getRecipientList().trim().length() > 0) {
            String[] typeRecipients = type.getRecipientList().split(COMMA_SEPARATED_SPLIT_REGEXP);
            for (i = 0; i < typeRecipients.length; ++i) {
                rcp.add(new InternetAddress(typeRecipients[i]));
            }
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])rcp.toArray(new InternetAddress[rcp.size()]));
        return msg;
    }

    private <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String transformText(EmailType type, String origText, B build) {
        String newText = origText.replaceAll(PROJECT_DEFAULT_BODY, Matcher.quoteReplacement(this.defaultContent)).replaceAll(PROJECT_DEFAULT_SUBJECT, Matcher.quoteReplacement(this.defaultSubject)).replaceAll(DEFAULT_BODY, Matcher.quoteReplacement(DESCRIPTOR.getDefaultBody())).replaceAll(DEFAULT_SUBJECT, Matcher.quoteReplacement(DESCRIPTOR.getDefaultSubject()));
        newText = this.replaceTokensWithContent(newText, type, build);
        return newText;
    }

    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String replaceTokensWithContent(String origText, EmailType type, AbstractBuild<P, B> build) {
        StringBuffer sb = new StringBuffer();
        Pattern tokenPattern = Pattern.compile("\\$[a-zA-Z0-9_]*");
        Matcher tokenMatcher = tokenPattern.matcher(origText);
        while (tokenMatcher.find()) {
            String replacement;
            String token = tokenMatcher.group().substring(1);
            EmailContent content = EMAIL_CONTENT_TYPE_MAP.get(token);
            if (content != null) {
                replacement = content.getContent(build, type);
                if (content.hasNestedContent()) {
                    replacement = this.replaceTokensWithContent(replacement, type, build);
                }
            } else {
                replacement = token;
            }
            tokenMatcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        tokenMatcher.appendTail(sb);
        return sb.toString();
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Publisher> {
        private String defaultSuffix;
        private String hudsonUrl;
        private String smtpAuthPassword;
        private String smtpAuthUsername;
        private String adminAddress;
        private String smtpHost;
        private boolean useSsl;
        private String smtpPort;
        private String defaultSubject;
        private String defaultBody;

        public String getDisplayName() {
            return "Editable Email Notification";
        }

        public String getAdminAddress() {
            String v = this.adminAddress;
            if (v == null) {
                v = "address not configured yet <nobody>";
            }
            return v;
        }

        public String getDefaultSuffix() {
            return this.defaultSuffix;
        }

        public Session createSession() {
            Properties props = new Properties(System.getProperties());
            if (this.smtpHost != null) {
                props.put("mail.smtp.host", this.smtpHost);
            }
            if (this.smtpPort != null) {
                props.put("mail.smtp.port", this.smtpPort);
            }
            if (this.useSsl) {
                props.put("mail.smtp.auth", "true");
                if (props.getProperty("mail.smtp.socketFactory.port") == null) {
                    String port = this.smtpPort == null ? "465" : this.smtpPort;
                    props.put("mail.smtp.port", port);
                    props.put("mail.smtp.socketFactory.port", port);
                }
                if (props.getProperty("mail.smtp.socketFactory.class") == null) {
                    props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                }
                props.put("mail.smtp.socketFactory.fallback", "false");
            }
            return Session.getInstance((Properties)props, (Authenticator)this.getAuthenticator());
        }

        private Authenticator getAuthenticator() {
            String un = this.getSmtpAuthUsername();
            if (un == null) {
                return null;
            }
            return new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(DescriptorImpl.this.getSmtpAuthUsername(), DescriptorImpl.this.getSmtpAuthPassword());
                }
            };
        }

        public String getHudsonUrl() {
            if (this.hudsonUrl == null) {
                return Hudson.getInstance().getRootUrl();
            }
            return this.hudsonUrl;
        }

        public String getSmtpServer() {
            return this.smtpHost;
        }

        public String getSmtpAuthUsername() {
            return this.smtpAuthUsername;
        }

        public String getSmtpAuthPassword() {
            return this.smtpAuthPassword;
        }

        public boolean getUseSsl() {
            return this.useSsl;
        }

        public String getSmtpPort() {
            return this.smtpPort;
        }

        public String getDefaultBody() {
            return this.defaultBody;
        }

        public String getDefaultSubject() {
            return this.defaultSubject;
        }

        public Publisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            String listRecipients = req.getParameter("recipientlist_recipients");
            ExtendedEmailPublisher m = new ExtendedEmailPublisher();
            m.recipientList = listRecipients;
            m.defaultSubject = req.getParameter("project_default_subject");
            m.defaultContent = req.getParameter("project_default_content");
            m.configuredTriggers = new ArrayList();
            for (String mailerId : EMAIL_TRIGGER_TYPE_MAP.keySet()) {
                EmailType type = this.createMailType(req, mailerId);
                if (type == null) continue;
                EmailTrigger trigger = ((EmailTriggerDescriptor)EMAIL_TRIGGER_TYPE_MAP.get(mailerId)).getNewInstance(type);
                m.configuredTriggers.add(trigger);
            }
            req.bindParameters((Object)m, "ext_mailer_");
            return m;
        }

        private EmailType createMailType(StaplerRequest req, String mailType) {
            if (req.getParameter("mailer." + mailType + ".configured") == null) {
                return null;
            }
            if (!req.getParameter("mailer." + mailType + ".configured").equalsIgnoreCase("true")) {
                return null;
            }
            EmailType m = new EmailType();
            String prefix = "mailer." + mailType + ".";
            m.setSubject(req.getParameter(prefix + "subject"));
            m.setBody(req.getParameter(prefix + "body"));
            m.setRecipientList(req.getParameter(prefix + "recipientList"));
            m.setSendToRecipientList(req.getParameter(prefix + "sendToRecipientList") != null);
            m.setSendToDevelopers(req.getParameter(prefix + "sendToDevelopers") != null);
            m.setIncludeCulprits(req.getParameter(prefix + "includeCulprits") != null);
            return m;
        }

        public DescriptorImpl() {
            super(ExtendedEmailPublisher.class);
            this.load();
            if (this.defaultBody == null && this.defaultSubject == null) {
                this.defaultBody = ExtendedEmailPublisher.DEFAULT_BODY_TEXT;
                this.defaultSubject = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
            }
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            this.smtpHost = this.nullify(req.getParameter("ext_mailer_smtp_server"));
            this.adminAddress = req.getParameter("ext_mailer_admin_address");
            this.defaultSuffix = this.nullify(req.getParameter("ext_mailer_default_suffix"));
            String url = this.nullify(req.getParameter("ext_mailer_hudson_url"));
            if (url != null && !url.endsWith("/")) {
                url = url + '/';
            }
            if (url == null) {
                url = Hudson.getInstance().getRootUrl();
            }
            this.hudsonUrl = url;
            if (req.getParameter("extmailer.useSMTPAuth") != null) {
                this.smtpAuthUsername = this.nullify(req.getParameter("extmailer.SMTPAuth.userName"));
                this.smtpAuthPassword = this.nullify(req.getParameter("extmailer.SMTPAuth.password"));
            } else {
                this.smtpAuthPassword = null;
                this.smtpAuthUsername = null;
            }
            this.useSsl = req.getParameter("ext_mailer_smtp_use_ssl") != null;
            this.smtpPort = this.nullify(req.getParameter("ext_mailer_smtp_port"));
            this.defaultSubject = this.nullify(req.getParameter("ext_mailer_default_subject"));
            this.defaultBody = this.nullify(req.getParameter("ext_mailer_default_body"));
            this.save();
            return super.configure(req);
        }

        private String nullify(String v) {
            if (v != null && v.length() == 0) {
                v = null;
            }
            return v;
        }

        public String getHelpFile() {
            return "/plugin/email-ext/help-config.html";
        }

        public void doAddressCheck(StaplerRequest req, StaplerResponse rsp, final @QueryParameter(value="value") String value) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    try {
                        new InternetAddress(value);
                        this.ok();
                    }
                    catch (AddressException e) {
                        this.error(e.getMessage());
                    }
                }
            }.process();
        }

        public void doRecipientListRecipientsCheck(StaplerRequest req, StaplerResponse rsp, final @QueryParameter(value="value") String value) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    if (value != null && value.trim().length() > 0) {
                        String[] names = value.split(ExtendedEmailPublisher.COMMA_SEPARATED_SPLIT_REGEXP);
                        try {
                            for (int i = 0; i < names.length; ++i) {
                                if (names[i].trim().length() <= 0) continue;
                                new InternetAddress(names[i]);
                            }
                            this.ok();
                        }
                        catch (AddressException e) {
                            this.error(e.getMessage());
                        }
                    } else {
                        this.ok();
                    }
                }
            }.process();
        }
    }
}

