/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.plugins.emailext.plugins.content.ChangesSinceLastBuildContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangesSinceLastSuccessfulBuildContent
implements EmailContent {
    private static final String TOKEN = "CHANGES_SINCE_LAST_SUCCESS";

    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, EmailType emailType) {
        if (build.getPreviousBuild() == null) {
            return "";
        }
        ChangesSinceLastBuildContent changes = new ChangesSinceLastBuildContent();
        AbstractBuild firstIncludedBuild = build;
        AbstractBuild prev = (AbstractBuild)firstIncludedBuild.getPreviousBuild();
        while (prev != null && prev.getResult() == Result.FAILURE) {
            firstIncludedBuild = prev;
            prev = (AbstractBuild)firstIncludedBuild.getPreviousBuild();
        }
        StringBuffer sb = new StringBuffer();
        AbstractBuild currentIncludedBuild = null;
        while (currentIncludedBuild != build) {
            currentIncludedBuild = currentIncludedBuild == null ? firstIncludedBuild : (AbstractBuild)currentIncludedBuild.getNextBuild();
            sb.append("Changes for Build #");
            sb.append(currentIncludedBuild.getNumber());
            sb.append("\n");
            sb.append(changes.getContent(currentIncludedBuild, emailType));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String getToken() {
        return TOKEN;
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }

    @Override
    public String getHelpText() {
        return "Displays the changes since the last successful build.";
    }
}

