/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.AbstractTestResultAction;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailedTestsContent
implements EmailContent {
    @Override
    public String getToken() {
        return "FAILED_TESTS";
    }

    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, EmailType emailType) {
        StringBuffer buffer = new StringBuffer();
        AbstractTestResultAction testResult = build.getTestResultAction();
        if (null == testResult) {
            return "No tests ran.";
        }
        int failCount = testResult.getFailCount();
        if (failCount == 0) {
            buffer.append("All tests passed");
        } else {
            buffer.append(failCount);
            buffer.append(" tests failed.");
            buffer.append('\n');
            List failedTests = testResult.getFailedTests();
            for (CaseResult failedTest : failedTests) {
                this.outputTest(buffer, failedTest);
            }
        }
        return buffer.toString();
    }

    private void outputTest(StringBuffer buffer, CaseResult failedTest) {
        buffer.append(failedTest.getStatus().toString());
        buffer.append(":  ");
        buffer.append(failedTest.getClassName());
        buffer.append("\n\n");
        buffer.append("Error Message:\n");
        buffer.append(failedTest.getErrorDetails());
        buffer.append("\n\nStack Trace:\n");
        buffer.append(failedTest.getErrorStackTrace());
        buffer.append("\n\n");
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }

    @Override
    public String getHelpText() {
        return "Displays failing unit test information, if any tests have failed.";
    }
}

