/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StillFailingTrigger
extends EmailTrigger {
    public static final String TRIGGER_NAME = "Still Failing";
    public static DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> boolean trigger(B build) {
        AbstractBuild prevBuild;
        Result buildResult = build.getResult();
        return buildResult == Result.FAILURE && (prevBuild = (AbstractBuild)build.getPreviousBuild()) != null && prevBuild.getResult() == Result.FAILURE;
    }

    @Override
    public EmailTriggerDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public boolean getDefaultSendToDevs() {
        return true;
    }

    @Override
    public boolean getDefaultSendToList() {
        return false;
    }

    public static final class DescriptorImpl
    extends EmailTriggerDescriptor {
        public DescriptorImpl() {
            this.addTriggerNameToReplace("Failure");
        }

        public String getTriggerName() {
            return StillFailingTrigger.TRIGGER_NAME;
        }

        public EmailTrigger newInstance() {
            return new StillFailingTrigger();
        }

        public String getHelpText() {
            return "An email will be sent if the build status is \"Failure\" for 2 or more builds in a row.";
        }
    }
}

