/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildLogContent
implements EmailContent {
    private static final int MAX_LINES = 250;
    private static final Logger LOGGER = Logger.getLogger(Mailer.class.getName());

    public String getToken() {
        return "BUILD_LOG";
    }

    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, EmailType emailType) {
        StringBuffer buffer = new StringBuffer();
        try {
            List lines = build.getLog(250);
            for (String line : lines) {
                buffer.append(line);
                buffer.append('\n');
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        return buffer.toString();
    }

    public boolean hasNestedContent() {
        return false;
    }

    public String getHelpText() {
        return "Displays last 250 lines of the build log";
    }
}

