/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.User;
import hudson.plugins.emailext.EmailExtException;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Mailer;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ExtendedEmailPublisher
extends Notifier {
    private static final Logger LOGGER = Logger.getLogger(Mailer.class.getName());
    public static final String COMMA_SEPARATED_SPLIT_REGEXP = "[,\\s]+";
    private static final Map<String, EmailTriggerDescriptor> EMAIL_TRIGGER_TYPE_MAP = new HashMap();
    public static final String DEFAULT_SUBJECT_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
    public static final String DEFAULT_BODY_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results.";
    public static final String PROJECT_DEFAULT_SUBJECT_TEXT = "$PROJECT_DEFAULT_SUBJECT";
    public static final String PROJECT_DEFAULT_BODY_TEXT = "$PROJECT_DEFAULT_CONTENT";
    public String recipientList;
    private List<EmailTrigger> configuredTriggers = new ArrayList();
    public String contentType;
    public String defaultSubject;
    public String defaultContent;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public static void addEmailTriggerType(EmailTriggerDescriptor triggerType) throws EmailExtException {
        if (EMAIL_TRIGGER_TYPE_MAP.containsKey(triggerType.getMailerId())) {
            throw new EmailExtException("An email trigger type with name " + triggerType.getTriggerName() + " was already added.");
        }
        EMAIL_TRIGGER_TYPE_MAP.put(triggerType.getMailerId(), triggerType);
    }

    public static void removeEmailTriggerType(EmailTriggerDescriptor triggerType) {
        if (EMAIL_TRIGGER_TYPE_MAP.containsKey(triggerType.getMailerId())) {
            EMAIL_TRIGGER_TYPE_MAP.remove(triggerType.getMailerId());
        }
    }

    public static EmailTriggerDescriptor getEmailTriggerType(String mailerId) {
        return (EmailTriggerDescriptor)EMAIL_TRIGGER_TYPE_MAP.get(mailerId);
    }

    public static Collection<EmailTriggerDescriptor> getEmailTriggers() {
        return EMAIL_TRIGGER_TYPE_MAP.values();
    }

    public static Collection<String> getEmailTriggerNames() {
        return EMAIL_TRIGGER_TYPE_MAP.keySet();
    }

    public static List<EmailTrigger> getTriggersForNonConfiguredInstance() {
        ArrayList<EmailTrigger> retList = new ArrayList<EmailTrigger>();
        for (String mailerId : EMAIL_TRIGGER_TYPE_MAP.keySet()) {
            retList.add(((EmailTriggerDescriptor)EMAIL_TRIGGER_TYPE_MAP.get(mailerId)).getNewInstance(null));
        }
        return retList;
    }

    public List<EmailTrigger> getConfiguredTriggers() {
        if (this.configuredTriggers == null) {
            this.configuredTriggers = new ArrayList();
        }
        return this.configuredTriggers;
    }

    public List<EmailTrigger> getNonConfiguredTriggers() {
        List confTriggers = this.getConfiguredTriggers();
        ArrayList<EmailTrigger> retList = new ArrayList<EmailTrigger>();
        for (String mailerId : EMAIL_TRIGGER_TYPE_MAP.keySet()) {
            boolean contains = false;
            for (EmailTrigger trigger : confTriggers) {
                if (!trigger.getDescriptor().getMailerId().equals(mailerId)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            retList.add(((EmailTriggerDescriptor)EMAIL_TRIGGER_TYPE_MAP.get(mailerId)).getNewInstance(null));
        }
        return retList;
    }

    public boolean isConfigured() {
        return !this.getConfiguredTriggers().isEmpty();
    }

    public boolean getConfigured() {
        return this.isConfigured();
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this._perform(build, launcher, listener);
    }

    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> boolean _perform(B build, Launcher launcher, BuildListener listener) throws InterruptedException {
        boolean emailTriggered = false;
        HashMap<String, EmailTrigger> triggered = new HashMap<String, EmailTrigger>();
        for (EmailTrigger trigger : this.configuredTriggers) {
            if (!trigger.trigger(build)) continue;
            String tName = trigger.getDescriptor().getTriggerName();
            triggered.put(tName, trigger);
            listener.getLogger().println("Email was triggered for: " + tName);
            emailTriggered = true;
        }
        ArrayList replacedTriggers = new ArrayList();
        for (String triggerName : triggered.keySet()) {
            replacedTriggers.addAll(((EmailTrigger)triggered.get(triggerName)).getDescriptor().getTriggerReplaceList());
        }
        for (String triggerName : replacedTriggers) {
            triggered.remove(triggerName);
            listener.getLogger().println("Trigger " + triggerName + " was overridden by another trigger and will not send an email.");
        }
        if (emailTriggered && triggered.isEmpty()) {
            listener.getLogger().println("There is a circular trigger replacement with the email triggers.  No email is sent.");
            return false;
        }
        if (triggered.isEmpty()) {
            listener.getLogger().println("No emails were triggered.");
            return true;
        }
        listener.getLogger().println("There are " + triggered.size() + " triggered emails.");
        for (String triggerName : triggered.keySet()) {
            listener.getLogger().println("Sending email for trigger: " + triggerName);
            this.sendMail(((EmailTrigger)triggered.get(triggerName)).getEmail(), build, listener);
        }
        return true;
    }

    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> boolean sendMail(EmailType mailType, B build, BuildListener listener) {
        try {
            MimeMessage msg = this.createMail(mailType, build, listener);
            Address[] allRecipients = msg.getAllRecipients();
            if (allRecipients != null) {
                StringBuffer buf = new StringBuffer("Sending e-mails to:");
                for (Address a : allRecipients) {
                    buf.append(' ').append(a);
                }
                listener.getLogger().println(buf);
                Transport.send((Message)msg);
                return true;
            }
            listener.getLogger().println("An attempt to send an e-mail to empty list of recipients, ignored.");
        }
        catch (MessagingException e) {
            LOGGER.log(Level.WARNING, "Could not send email.", e);
            e.printStackTrace(listener.error("Could not send email as a part of the post-build publishers."));
        }
        return false;
    }

    private <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> MimeMessage createMail(EmailType type, B build, BuildListener listener) throws MessagingException {
        MimeMessage msg;
        boolean overrideGlobalSettings = DESCRIPTOR.getOverrideGlobalSettings();
        if (!overrideGlobalSettings) {
            msg = new MimeMessage(Mailer.descriptor().createSession());
            msg.setFrom((Address)new InternetAddress(Mailer.descriptor().getAdminAddress()));
        } else {
            msg = new MimeMessage(DESCRIPTOR.createSession());
            msg.setFrom((Address)new InternetAddress(DESCRIPTOR.getAdminAddress()));
        }
        msg.setSentDate(new Date());
        String subject = new ContentBuilder().transformText(type.getSubject(), this, type, build);
        msg.setSubject(subject);
        String text = new ContentBuilder().transformText(type.getBody(), this, type, build);
        msg.setContent((Object)text, this.contentType);
        String messageContentType = this.contentType;
        if ((messageContentType == null || "default".equals(messageContentType)) && (messageContentType = DESCRIPTOR.getDefaultContentType()) == null) {
            messageContentType = "text/plain";
        }
        msg.setContent((Object)text, messageContentType);
        ArrayList<InternetAddress> recipientAddresses = new ArrayList<InternetAddress>();
        if (type.getSendToRecipientList()) {
            for (String recipient : this.recipientList.split("[,\\s]+")) {
                ExtendedEmailPublisher.addAddress(recipientAddresses, (String)recipient, (BuildListener)listener);
            }
        }
        if (type.getSendToDevelopers()) {
            HashSet<User> users;
            if (type.getIncludeCulprits()) {
                users = build.getCulprits();
            } else {
                users = new HashSet<User>();
                for (ChangeLogSet.Entry change : build.getChangeSet()) {
                    users.add(change.getAuthor());
                }
            }
            for (User user : users) {
                String adrs = ((Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)).getAddress();
                if (adrs != null) {
                    ExtendedEmailPublisher.addAddress(recipientAddresses, (String)adrs, (BuildListener)listener);
                    continue;
                }
                listener.getLogger().println("Failed to send e-mail to " + user.getFullName() + " because no e-mail address is known, and no default e-mail domain is configured");
            }
        }
        if (type.getRecipientList() != null && type.getRecipientList().trim().length() > 0) {
            String[] typeRecipients = type.getRecipientList().split("[,\\s]+");
            for (int i = 0; i < typeRecipients.length; ++i) {
                recipientAddresses.add(new InternetAddress(typeRecipients[i]));
            }
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])recipientAddresses.toArray(new InternetAddress[recipientAddresses.size()]));
        return msg;
    }

    private static void addAddress(List<InternetAddress> addresses, String address, BuildListener listener) {
        try {
            addresses.add(new InternetAddress(address));
        }
        catch (AddressException ae) {
            LOGGER.log(Level.WARNING, "Could not create email address.", ae);
            listener.getLogger().println("Failed to create e-mail address for " + address);
        }
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    static /* synthetic */ List access$002(ExtendedEmailPublisher x0, List x1) {
        x0.configuredTriggers = x1;
        return x0.configuredTriggers;
    }

    static /* synthetic */ Map access$100() {
        return EMAIL_TRIGGER_TYPE_MAP;
    }

    static /* synthetic */ List access$000(ExtendedEmailPublisher x0) {
        return x0.configuredTriggers;
    }
}

