/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.emailext.EmailExtException;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.tasks.Mailer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ContentBuilder {
    private static final Logger LOGGER = Logger.getLogger(Mailer.class.getName());
    private static final String DEFAULT_BODY = "\\$DEFAULT_CONTENT";
    private static final String DEFAULT_SUBJECT = "\\$DEFAULT_SUBJECT";
    private static final String PROJECT_DEFAULT_BODY = "\\$PROJECT_DEFAULT_CONTENT";
    private static final String PROJECT_DEFAULT_SUBJECT = "\\$PROJECT_DEFAULT_SUBJECT";
    private static final Map<String, EmailContent> EMAIL_CONTENT_TYPE_MAP = new LinkedHashMap();

    public static void addEmailContentType(EmailContent contentType) throws EmailExtException {
        if (EMAIL_CONTENT_TYPE_MAP.containsKey(contentType.getToken())) {
            throw new EmailExtException("An email content type with token name " + contentType.getToken() + " was already added.");
        }
        EMAIL_CONTENT_TYPE_MAP.put(contentType.getToken(), contentType);
    }

    public static void removeEmailContentType(EmailContent contentType) {
        if (EMAIL_CONTENT_TYPE_MAP.containsKey(contentType.getToken())) {
            EMAIL_CONTENT_TYPE_MAP.remove(contentType);
        }
    }

    public static EmailContent getEmailContentType(String token) {
        return (EmailContent)EMAIL_CONTENT_TYPE_MAP.get(token);
    }

    public static Collection<EmailContent> getEmailContentTypes() {
        return EMAIL_CONTENT_TYPE_MAP.values();
    }

    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String transformText(String origText, ExtendedEmailPublisher publisher, EmailType type, B build) {
        String newText = origText.replaceAll("\\$PROJECT_DEFAULT_CONTENT", Matcher.quoteReplacement(publisher.defaultContent)).replaceAll("\\$PROJECT_DEFAULT_SUBJECT", Matcher.quoteReplacement(publisher.defaultSubject)).replaceAll("\\$DEFAULT_CONTENT", Matcher.quoteReplacement(ExtendedEmailPublisher.DESCRIPTOR.getDefaultBody())).replaceAll("\\$DEFAULT_SUBJECT", Matcher.quoteReplacement(ExtendedEmailPublisher.DESCRIPTOR.getDefaultSubject()));
        newText = ContentBuilder.replaceTokensWithContent((String)newText, (ExtendedEmailPublisher)publisher, (EmailType)type, build);
        return newText;
    }

    private static <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String replaceTokensWithContent(String origText, ExtendedEmailPublisher publisher, EmailType type, AbstractBuild<P, B> build) {
        StringBuffer sb = new StringBuffer();
        Tokenizer tokenizer = new Tokenizer(origText);
        while (tokenizer.find()) {
            String replacement;
            String tokenName = tokenizer.getTokenName();
            Map args = tokenizer.getArgs();
            EmailContent content = (EmailContent)EMAIL_CONTENT_TYPE_MAP.get(tokenName);
            if (content != null) {
                try {
                    replacement = content.getContent(build, publisher, type, args);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Exception thrown while replacing " + tokenizer.group(), e);
                    replacement = "[[ Exception while replacing " + tokenName + ".  Please report this as a bug. ]]";
                }
                if (content.hasNestedContent()) {
                    replacement = ContentBuilder.replaceTokensWithContent((String)replacement, (ExtendedEmailPublisher)publisher, (EmailType)type, build);
                }
            } else {
                replacement = tokenizer.group();
            }
            tokenizer.appendReplacement(sb, replacement);
        }
        tokenizer.appendTail(sb);
        return sb.toString();
    }
}

