/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.Util;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.scm.ChangeLogSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangesSinceLastBuildContent
implements EmailContent {
    private static final String TOKEN = "CHANGES";
    private static final String SHOW_PATHS_ARG_NAME = "showPaths";
    private static final boolean SHOW_PATHS_DEFAULT_VALUE = false;
    private static final String FORMAT_ARG_NAME = "format";
    private static final String FORMAT_DEFAULT_VALUE = "[%a] %m\\n";
    private static final String FORMAT_DEFAULT_VALUE_WITH_PATHS = "[%a] %m%p\\n";
    private static final String PATH_FORMAT_ARG_NAME = "pathFormat";
    private static final String PATH_FORMAT_DEFAULT_VALUE = "\\t%p\\n";

    public String getToken() {
        return TOKEN;
    }

    public List<String> getArguments() {
        return Arrays.asList(SHOW_PATHS_ARG_NAME, FORMAT_ARG_NAME, PATH_FORMAT_ARG_NAME);
    }

    public String getHelpText() {
        return "Displays the changes since the last build.\n<ul>\n<li><i>showPaths</i> - if true, the paths modified by a commit are shown.<br>\nDefaults to false.\n<li><i>format</i> - for each commit listed, a string containing %X, where %X is one of %a for author, %d for date, %m for message, %p for paths, or %r for revision.  Not all revision systems support %d and %r.  If specified, <i>showPaths</i> is ignored.<br>\nDefaults to \"[%a] %m\\n\".\n<li><i>pathFormat</i> - a string containing %p to indicate how to print paths.<br>\nDefaults to \"\\t%p\\n\".\n</ul>\n";
    }

    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType emailType, Map<String, ?> args) {
        boolean showPaths = EmailContent.Args.get(args, (String)SHOW_PATHS_ARG_NAME, (boolean)false);
        String formatStringDefault = showPaths ? FORMAT_DEFAULT_VALUE_WITH_PATHS : FORMAT_DEFAULT_VALUE;
        String formatString = EmailContent.Args.get(args, (String)FORMAT_ARG_NAME, (String)formatStringDefault);
        String pathFormatString = EmailContent.Args.get(args, (String)PATH_FORMAT_ARG_NAME, (String)PATH_FORMAT_DEFAULT_VALUE);
        StringBuffer buf = new StringBuffer();
        for (ChangeLogSet.Entry entry : build.getChangeSet()) {
            this.appendEntry(buf, entry, formatString, pathFormatString);
        }
        return buf.toString();
    }

    private void appendEntry(StringBuffer buf, ChangeLogSet.Entry entry, String formatString, String pathFormatString) {
        Util.printf((StringBuffer)buf, (String)formatString, (Util.PrintfSpec)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean hasNestedContent() {
        return false;
    }
}

