/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.TaskListener;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailContent;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvContent
implements EmailContent {
    private static final String TOKEN = "ENV";
    private static final String VAR_ARG_NAME = "var";
    private static final String VAR_DEFAULT_VALUE = "";

    public String getToken() {
        return TOKEN;
    }

    public List<String> getArguments() {
        return Collections.singletonList(VAR_ARG_NAME);
    }

    public String getHelpText() {
        return "Displays an environment variable.\n<ul>\n<li><i>var</i> - the name of the environment variable to display.  If \"\", show all.<br>\nDefaults to \"\".\n</ul>\n";
    }

    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType emailType, Map<String, ?> args) throws IOException, InterruptedException {
        String var = EmailContent.Args.get(args, (String)VAR_ARG_NAME, (String)VAR_DEFAULT_VALUE);
        EnvVars env = build.getEnvironment(TaskListener.NULL);
        if (var.length() == 0) {
            return env.toString();
        }
        String value = (String)env.get(var);
        if (value == null) {
            value = VAR_DEFAULT_VALUE;
        }
        return value;
    }

    public boolean hasNestedContent() {
        return false;
    }
}

