/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.emailext.EmailExtException;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Mailer;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedEmailPublisher
extends Notifier {
    private static final Logger LOGGER = Logger.getLogger(Mailer.class.getName());
    public static final String COMMA_SEPARATED_SPLIT_REGEXP = "[,\\s]+";
    private static final Map<String, EmailTriggerDescriptor> EMAIL_TRIGGER_TYPE_MAP = new HashMap<String, EmailTriggerDescriptor>();
    public static final String DEFAULT_SUBJECT_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
    public static final String DEFAULT_BODY_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results.";
    public static final String PROJECT_DEFAULT_SUBJECT_TEXT = "$PROJECT_DEFAULT_SUBJECT";
    public static final String PROJECT_DEFAULT_BODY_TEXT = "$PROJECT_DEFAULT_CONTENT";
    public String recipientList;
    private List<EmailTrigger> configuredTriggers = new ArrayList<EmailTrigger>();
    public String contentType;
    public String defaultSubject;
    public String defaultContent;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public static void addEmailTriggerType(EmailTriggerDescriptor triggerType) throws EmailExtException {
        if (EMAIL_TRIGGER_TYPE_MAP.containsKey(triggerType.getMailerId())) {
            throw new EmailExtException("An email trigger type with name " + triggerType.getTriggerName() + " was already added.");
        }
        EMAIL_TRIGGER_TYPE_MAP.put(triggerType.getMailerId(), triggerType);
    }

    public static void removeEmailTriggerType(EmailTriggerDescriptor triggerType) {
        if (EMAIL_TRIGGER_TYPE_MAP.containsKey(triggerType.getMailerId())) {
            EMAIL_TRIGGER_TYPE_MAP.remove(triggerType.getMailerId());
        }
    }

    public static EmailTriggerDescriptor getEmailTriggerType(String mailerId) {
        return EMAIL_TRIGGER_TYPE_MAP.get(mailerId);
    }

    public static Collection<EmailTriggerDescriptor> getEmailTriggers() {
        return EMAIL_TRIGGER_TYPE_MAP.values();
    }

    public static Collection<String> getEmailTriggerNames() {
        return EMAIL_TRIGGER_TYPE_MAP.keySet();
    }

    public static List<EmailTrigger> getTriggersForNonConfiguredInstance() {
        ArrayList<EmailTrigger> retList = new ArrayList<EmailTrigger>();
        for (String mailerId : EMAIL_TRIGGER_TYPE_MAP.keySet()) {
            retList.add(EMAIL_TRIGGER_TYPE_MAP.get(mailerId).getNewInstance(null));
        }
        return retList;
    }

    public List<EmailTrigger> getConfiguredTriggers() {
        if (this.configuredTriggers == null) {
            this.configuredTriggers = new ArrayList<EmailTrigger>();
        }
        return this.configuredTriggers;
    }

    public List<EmailTrigger> getNonConfiguredTriggers() {
        List<EmailTrigger> confTriggers = this.getConfiguredTriggers();
        ArrayList<EmailTrigger> retList = new ArrayList<EmailTrigger>();
        for (String mailerId : EMAIL_TRIGGER_TYPE_MAP.keySet()) {
            boolean contains = false;
            for (EmailTrigger trigger : confTriggers) {
                if (!trigger.getDescriptor().getMailerId().equals(mailerId)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            retList.add(EMAIL_TRIGGER_TYPE_MAP.get(mailerId).getNewInstance(null));
        }
        return retList;
    }

    public boolean isConfigured() {
        return !this.getConfiguredTriggers().isEmpty();
    }

    public boolean getConfigured() {
        return this.isConfigured();
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this._perform(build, launcher, listener);
    }

    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> boolean _perform(B build, Launcher launcher, BuildListener listener) throws InterruptedException {
        boolean emailTriggered = false;
        HashMap<String, EmailTrigger> triggered = new HashMap<String, EmailTrigger>();
        for (EmailTrigger trigger : this.configuredTriggers) {
            if (!trigger.trigger(build)) continue;
            String tName = trigger.getDescriptor().getTriggerName();
            triggered.put(tName, trigger);
            listener.getLogger().println("Email was triggered for: " + tName);
            emailTriggered = true;
        }
        ArrayList<String> replacedTriggers = new ArrayList<String>();
        for (String triggerName : triggered.keySet()) {
            replacedTriggers.addAll(((EmailTrigger)triggered.get(triggerName)).getDescriptor().getTriggerReplaceList());
        }
        for (String triggerName : replacedTriggers) {
            triggered.remove(triggerName);
            listener.getLogger().println("Trigger " + triggerName + " was overridden by another trigger and will not send an email.");
        }
        if (emailTriggered && triggered.isEmpty()) {
            listener.getLogger().println("There is a circular trigger replacement with the email triggers.  No email is sent.");
            return false;
        }
        if (triggered.isEmpty()) {
            listener.getLogger().println("No emails were triggered.");
            return true;
        }
        listener.getLogger().println("There are " + triggered.size() + " triggered emails.");
        for (String triggerName : triggered.keySet()) {
            listener.getLogger().println("Sending email for trigger: " + triggerName);
            this.sendMail(((EmailTrigger)triggered.get(triggerName)).getEmail(), build, listener);
        }
        return true;
    }

    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> boolean sendMail(EmailType mailType, B build, BuildListener listener) {
        try {
            MimeMessage msg = this.createMail(mailType, build, listener);
            Address[] allRecipients = msg.getAllRecipients();
            if (allRecipients != null) {
                StringBuffer buf = new StringBuffer("Sending e-mails to:");
                for (Address a : allRecipients) {
                    buf.append(' ').append(a);
                }
                listener.getLogger().println(buf);
                Transport.send((Message)msg);
                return true;
            }
            listener.getLogger().println("An attempt to send an e-mail to empty list of recipients, ignored.");
        }
        catch (MessagingException e) {
            LOGGER.log(Level.WARNING, "Could not send email.", e);
            e.printStackTrace(listener.error("Could not send email as a part of the post-build publishers."));
        }
        return false;
    }

    private <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> MimeMessage createMail(EmailType type, B build, BuildListener listener) throws MessagingException {
        MimeMessage msg;
        boolean overrideGlobalSettings = DESCRIPTOR.getOverrideGlobalSettings();
        if (!overrideGlobalSettings) {
            msg = new MimeMessage(Mailer.descriptor().createSession());
            msg.setFrom((Address)new InternetAddress(Mailer.descriptor().getAdminAddress()));
        } else {
            msg = new MimeMessage(DESCRIPTOR.createSession());
            msg.setFrom((Address)new InternetAddress(DESCRIPTOR.getAdminAddress()));
        }
        msg.setSentDate(new Date());
        String subject = new ContentBuilder().transformText(type.getSubject(), this, type, build);
        msg.setSubject(subject);
        String text = new ContentBuilder().transformText(type.getBody(), this, type, build);
        msg.setContent((Object)text, this.contentType);
        String messageContentType = this.contentType;
        if ((messageContentType == null || "default".equals(messageContentType)) && (messageContentType = DESCRIPTOR.getDefaultContentType()) == null) {
            messageContentType = "text/plain";
        }
        msg.setContent((Object)text, messageContentType);
        ArrayList<InternetAddress> recipientAddresses = new ArrayList<InternetAddress>();
        if (type.getSendToRecipientList()) {
            for (String recipient : this.recipientList.split(COMMA_SEPARATED_SPLIT_REGEXP)) {
                ExtendedEmailPublisher.addAddress(recipientAddresses, recipient, listener);
            }
        }
        if (type.getSendToDevelopers()) {
            HashSet<User> users;
            if (type.getIncludeCulprits()) {
                users = build.getCulprits();
            } else {
                users = new HashSet<User>();
                for (ChangeLogSet.Entry change : build.getChangeSet()) {
                    users.add(change.getAuthor());
                }
            }
            for (User user : users) {
                String adrs = ((Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)).getAddress();
                if (adrs != null) {
                    ExtendedEmailPublisher.addAddress(recipientAddresses, adrs, listener);
                    continue;
                }
                listener.getLogger().println("Failed to send e-mail to " + user.getFullName() + " because no e-mail address is known, and no default e-mail domain is configured");
            }
        }
        if (type.getRecipientList() != null && type.getRecipientList().trim().length() > 0) {
            String[] typeRecipients = type.getRecipientList().split(COMMA_SEPARATED_SPLIT_REGEXP);
            for (int i = 0; i < typeRecipients.length; ++i) {
                recipientAddresses.add(new InternetAddress(typeRecipients[i]));
            }
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])recipientAddresses.toArray(new InternetAddress[recipientAddresses.size()]));
        return msg;
    }

    private static void addAddress(List<InternetAddress> addresses, String address, BuildListener listener) {
        try {
            addresses.add(new InternetAddress(address));
        }
        catch (AddressException ae) {
            LOGGER.log(Level.WARNING, "Could not create email address.", ae);
            listener.getLogger().println("Failed to create e-mail address for " + address);
        }
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String defaultSuffix;
        private String hudsonUrl;
        private String smtpAuthPassword;
        private String smtpAuthUsername;
        private String adminAddress;
        private String smtpHost;
        private boolean useSsl;
        private String smtpPort;
        private String defaultContentType;
        private String defaultSubject;
        private String defaultBody;
        private boolean overrideGlobalSettings;

        public String getDisplayName() {
            return "Editable Email Notification";
        }

        public String getAdminAddress() {
            String v = this.adminAddress;
            if (v == null) {
                v = "address not configured yet <nobody>";
            }
            return v;
        }

        public String getDefaultSuffix() {
            return this.defaultSuffix;
        }

        public Session createSession() {
            Properties props = new Properties(System.getProperties());
            if (this.smtpHost != null) {
                props.put("mail.smtp.host", this.smtpHost);
            }
            if (this.smtpPort != null) {
                props.put("mail.smtp.port", this.smtpPort);
            }
            if (this.useSsl) {
                props.put("mail.smtp.auth", "true");
                if (props.getProperty("mail.smtp.socketFactory.port") == null) {
                    String port = this.smtpPort == null ? "465" : this.smtpPort;
                    props.put("mail.smtp.port", port);
                    props.put("mail.smtp.socketFactory.port", port);
                }
                if (props.getProperty("mail.smtp.socketFactory.class") == null) {
                    props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                }
                props.put("mail.smtp.socketFactory.fallback", "false");
            }
            return Session.getInstance((Properties)props, (Authenticator)this.getAuthenticator());
        }

        private Authenticator getAuthenticator() {
            String un = this.getSmtpAuthUsername();
            if (un == null) {
                return null;
            }
            return new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(DescriptorImpl.this.getSmtpAuthUsername(), DescriptorImpl.this.getSmtpAuthPassword());
                }
            };
        }

        public String getHudsonUrl() {
            if (this.hudsonUrl == null) {
                return Hudson.getInstance().getRootUrl();
            }
            return this.hudsonUrl;
        }

        public String getSmtpServer() {
            return this.smtpHost;
        }

        public String getSmtpAuthUsername() {
            return this.smtpAuthUsername;
        }

        public String getSmtpAuthPassword() {
            return this.smtpAuthPassword;
        }

        public boolean getUseSsl() {
            return this.useSsl;
        }

        public String getSmtpPort() {
            return this.smtpPort;
        }

        public String getDefaultContentType() {
            return this.defaultContentType;
        }

        public String getDefaultSubject() {
            return this.defaultSubject;
        }

        public String getDefaultBody() {
            return this.defaultBody;
        }

        public boolean getOverrideGlobalSettings() {
            return this.overrideGlobalSettings;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String listRecipients = formData.getString("recipientlist_recipients");
            ExtendedEmailPublisher m = new ExtendedEmailPublisher();
            m.recipientList = listRecipients;
            m.contentType = formData.getString("project_content_type");
            m.defaultSubject = formData.getString("project_default_subject");
            m.defaultContent = formData.getString("project_default_content");
            m.configuredTriggers = new ArrayList();
            for (String mailerId : EMAIL_TRIGGER_TYPE_MAP.keySet()) {
                if (!"true".equalsIgnoreCase(formData.optString("mailer_" + mailerId + "_configured"))) continue;
                EmailType type = this.createMailType(formData, mailerId);
                EmailTrigger trigger = ((EmailTriggerDescriptor)EMAIL_TRIGGER_TYPE_MAP.get(mailerId)).getNewInstance(type);
                m.configuredTriggers.add(trigger);
            }
            return m;
        }

        private EmailType createMailType(JSONObject formData, String mailType) {
            EmailType m = new EmailType();
            String prefix = "mailer_" + mailType + '_';
            m.setSubject(formData.getString(prefix + "subject"));
            m.setBody(formData.getString(prefix + "body"));
            m.setRecipientList(formData.getString(prefix + "recipientList"));
            m.setSendToRecipientList(formData.optBoolean(prefix + "sendToRecipientList"));
            m.setSendToDevelopers(formData.optBoolean(prefix + "sendToDevelopers"));
            m.setIncludeCulprits(formData.optBoolean(prefix + "includeCulprits"));
            return m;
        }

        public DescriptorImpl() {
            super(ExtendedEmailPublisher.class);
            this.load();
            if (this.defaultBody == null && this.defaultSubject == null) {
                this.defaultBody = ExtendedEmailPublisher.DEFAULT_BODY_TEXT;
                this.defaultSubject = ExtendedEmailPublisher.DEFAULT_SUBJECT_TEXT;
            }
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.smtpHost = this.nullify(req.getParameter("ext_mailer_smtp_server"));
            this.adminAddress = req.getParameter("ext_mailer_admin_address");
            this.defaultSuffix = this.nullify(req.getParameter("ext_mailer_default_suffix"));
            String url = this.nullify(req.getParameter("ext_mailer_hudson_url"));
            if (url != null && !url.endsWith("/")) {
                url = url + '/';
            }
            if (url == null) {
                url = Hudson.getInstance().getRootUrl();
            }
            this.hudsonUrl = url;
            if (req.getParameter("extmailer.useSMTPAuth") != null) {
                this.smtpAuthUsername = this.nullify(req.getParameter("extmailer.SMTPAuth.userName"));
                this.smtpAuthPassword = this.nullify(req.getParameter("extmailer.SMTPAuth.password"));
            } else {
                this.smtpAuthPassword = null;
                this.smtpAuthUsername = null;
            }
            this.useSsl = req.getParameter("ext_mailer_smtp_use_ssl") != null;
            this.smtpPort = this.nullify(req.getParameter("ext_mailer_smtp_port"));
            this.defaultContentType = this.nullify(req.getParameter("ext_mailer_default_content_type"));
            this.defaultSubject = this.nullify(req.getParameter("ext_mailer_default_subject"));
            this.defaultBody = this.nullify(req.getParameter("ext_mailer_default_body"));
            this.overrideGlobalSettings = req.getParameter("ext_mailer_use_global_settings") != null;
            this.save();
            return super.configure(req, formData);
        }

        private String nullify(String v) {
            if (v != null && v.length() == 0) {
                v = null;
            }
            return v;
        }

        public String getHelpFile() {
            return "/plugin/email-ext/help/main.html";
        }

        public FormValidation doAddressCheck(@QueryParameter String value) throws IOException, ServletException {
            try {
                new InternetAddress(value);
                return FormValidation.ok();
            }
            catch (AddressException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doRecipientListRecipientsCheck(@QueryParameter String value) throws IOException, ServletException {
            if (value != null && value.trim().length() > 0) {
                String[] names = value.split(ExtendedEmailPublisher.COMMA_SEPARATED_SPLIT_REGEXP);
                try {
                    for (int i = 0; i < names.length; ++i) {
                        if (names[i].trim().length() <= 0) continue;
                        new InternetAddress(names[i]);
                    }
                }
                catch (AddressException e) {
                    return FormValidation.error((String)e.getMessage());
                }
            }
            return FormValidation.ok();
        }
    }
}

