/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.Util;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.scm.ChangeLogSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangesSinceLastBuildContent
implements EmailContent {
    private static final String TOKEN = "CHANGES";
    private static final String SHOW_PATHS_ARG_NAME = "showPaths";
    private static final boolean SHOW_PATHS_DEFAULT_VALUE = false;
    private static final String FORMAT_ARG_NAME = "format";
    private static final String FORMAT_DEFAULT_VALUE = "[%a] %m\\n";
    private static final String FORMAT_DEFAULT_VALUE_WITH_PATHS = "[%a] %m%p\\n";
    private static final String PATH_FORMAT_ARG_NAME = "pathFormat";
    private static final String PATH_FORMAT_DEFAULT_VALUE = "\\t%p\\n";

    @Override
    public String getToken() {
        return TOKEN;
    }

    @Override
    public List<String> getArguments() {
        return Arrays.asList(SHOW_PATHS_ARG_NAME, FORMAT_ARG_NAME, PATH_FORMAT_ARG_NAME);
    }

    @Override
    public String getHelpText() {
        return "Displays the changes since the last build.\n<ul>\n<li><i>showPaths</i> - if true, the paths modified by a commit are shown.<br>\nDefaults to false.\n<li><i>format</i> - for each commit listed, a string containing %X, where %X is one of %a for author, %d for date, %m for message, %p for paths, or %r for revision.  Not all revision systems support %d and %r.  If specified, <i>showPaths</i> is ignored.<br>\nDefaults to \"[%a] %m\\n\".\n<li><i>pathFormat</i> - a string containing %p to indicate how to print paths.<br>\nDefaults to \"\\t%p\\n\".\n</ul>\n";
    }

    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType emailType, Map<String, ?> args) {
        boolean showPaths = EmailContent.Args.get(args, SHOW_PATHS_ARG_NAME, false);
        String formatStringDefault = showPaths ? FORMAT_DEFAULT_VALUE_WITH_PATHS : FORMAT_DEFAULT_VALUE;
        String formatString = EmailContent.Args.get(args, FORMAT_ARG_NAME, formatStringDefault);
        String pathFormatString = EmailContent.Args.get(args, PATH_FORMAT_ARG_NAME, PATH_FORMAT_DEFAULT_VALUE);
        StringBuffer buf = new StringBuffer();
        for (ChangeLogSet.Entry entry : build.getChangeSet()) {
            this.appendEntry(buf, entry, formatString, pathFormatString);
        }
        return buf.toString();
    }

    private void appendEntry(StringBuffer buf, final ChangeLogSet.Entry entry, String formatString, final String pathFormatString) {
        Util.printf(buf, formatString, new Util.PrintfSpec(){

            public boolean printSpec(StringBuffer buf, char formatChar) {
                switch (formatChar) {
                    case 'a': {
                        buf.append(entry.getAuthor().getFullName());
                        return true;
                    }
                    case 'd': {
                        try {
                            Method getDateMethod = entry.getClass().getMethod("getDate", new Class[0]);
                            buf.append(getDateMethod.invoke((Object)entry, new Object[0]));
                        }
                        catch (NoSuchMethodException e) {
                        }
                        catch (IllegalAccessException e) {
                        }
                        catch (InvocationTargetException e) {
                            // empty catch block
                        }
                        return true;
                    }
                    case 'm': {
                        String m = entry.getMsg();
                        buf.append(m);
                        if (!m.endsWith("\n")) {
                            buf.append('\n');
                        }
                        return true;
                    }
                    case 'p': {
                        Collection affectedPaths = entry.getAffectedPaths();
                        for (final String affectedPath : affectedPaths) {
                            Util.printf(buf, pathFormatString, new Util.PrintfSpec(){

                                public boolean printSpec(StringBuffer buf, char formatChar) {
                                    if (formatChar == 'p') {
                                        buf.append(affectedPath);
                                        return true;
                                    }
                                    return false;
                                }
                            });
                        }
                        return true;
                    }
                    case 'r': {
                        try {
                            Method getRevisionMethod = entry.getClass().getMethod("getRevision", new Class[0]);
                            buf.append(getRevisionMethod.invoke((Object)entry, new Object[0]));
                        }
                        catch (NoSuchMethodException e) {
                        }
                        catch (IllegalAccessException e) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                        return true;
                    }
                }
                return false;
            }
        });
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }
}

