/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.emailext.EmailExtException;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.MailMessageIdAction;
import hudson.tasks.Mailer;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ExtendedEmailPublisher
extends Notifier {
    private static final Logger LOGGER = Logger.getLogger(Mailer.class.getName());
    public static final String COMMA_SEPARATED_SPLIT_REGEXP = "[,\\s]+";
    private static final Map<String, EmailTriggerDescriptor> EMAIL_TRIGGER_TYPE_MAP = new HashMap();
    public static final String DEFAULT_SUBJECT_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
    public static final String DEFAULT_BODY_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results.";
    public static final String PROJECT_DEFAULT_SUBJECT_TEXT = "$PROJECT_DEFAULT_SUBJECT";
    public static final String PROJECT_DEFAULT_BODY_TEXT = "$PROJECT_DEFAULT_CONTENT";
    public static final String CHARSET = "utf-8";
    public String recipientList;
    private List<EmailTrigger> configuredTriggers = new ArrayList();
    public String contentType;
    public String defaultSubject;
    public String defaultContent;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public static void addEmailTriggerType(EmailTriggerDescriptor triggerType) throws EmailExtException {
        if (EMAIL_TRIGGER_TYPE_MAP.containsKey(triggerType.getMailerId())) {
            throw new EmailExtException("An email trigger type with name " + triggerType.getTriggerName() + " was already added.");
        }
        EMAIL_TRIGGER_TYPE_MAP.put(triggerType.getMailerId(), triggerType);
    }

    public static void removeEmailTriggerType(EmailTriggerDescriptor triggerType) {
        if (EMAIL_TRIGGER_TYPE_MAP.containsKey(triggerType.getMailerId())) {
            EMAIL_TRIGGER_TYPE_MAP.remove(triggerType.getMailerId());
        }
    }

    public static EmailTriggerDescriptor getEmailTriggerType(String mailerId) {
        return (EmailTriggerDescriptor)EMAIL_TRIGGER_TYPE_MAP.get(mailerId);
    }

    public static Collection<EmailTriggerDescriptor> getEmailTriggers() {
        return EMAIL_TRIGGER_TYPE_MAP.values();
    }

    public static Collection<String> getEmailTriggerNames() {
        return EMAIL_TRIGGER_TYPE_MAP.keySet();
    }

    public static List<EmailTrigger> getTriggersForNonConfiguredInstance() {
        ArrayList<EmailTrigger> retList = new ArrayList<EmailTrigger>();
        for (String mailerId : EMAIL_TRIGGER_TYPE_MAP.keySet()) {
            retList.add(((EmailTriggerDescriptor)EMAIL_TRIGGER_TYPE_MAP.get(mailerId)).getNewInstance(null));
        }
        return retList;
    }

    public List<EmailTrigger> getConfiguredTriggers() {
        if (this.configuredTriggers == null) {
            this.configuredTriggers = new ArrayList();
        }
        return this.configuredTriggers;
    }

    public List<EmailTrigger> getNonConfiguredTriggers() {
        List confTriggers = this.getConfiguredTriggers();
        ArrayList<EmailTrigger> retList = new ArrayList<EmailTrigger>();
        for (String mailerId : EMAIL_TRIGGER_TYPE_MAP.keySet()) {
            boolean contains = false;
            for (EmailTrigger trigger : confTriggers) {
                if (!trigger.getDescriptor().getMailerId().equals(mailerId)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            retList.add(((EmailTriggerDescriptor)EMAIL_TRIGGER_TYPE_MAP.get(mailerId)).getNewInstance(null));
        }
        return retList;
    }

    public boolean isConfigured() {
        return !this.getConfiguredTriggers().isEmpty();
    }

    public boolean getConfigured() {
        return this.isConfigured();
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return this._perform(build, listener, true);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this._perform(build, listener, false);
    }

    private boolean _perform(AbstractBuild<?, ?> build, BuildListener listener, boolean forPreBuild) {
        boolean emailTriggered = false;
        HashMap<String, EmailTrigger> triggered = new HashMap<String, EmailTrigger>();
        for (EmailTrigger trigger : this.configuredTriggers) {
            if (trigger.isPreBuild() != forPreBuild || !trigger.trigger(build)) continue;
            String tName = trigger.getDescriptor().getTriggerName();
            triggered.put(tName, trigger);
            listener.getLogger().println("Email was triggered for: " + tName);
            emailTriggered = true;
        }
        ArrayList replacedTriggers = new ArrayList();
        for (String triggerName : triggered.keySet()) {
            replacedTriggers.addAll(((EmailTrigger)triggered.get(triggerName)).getDescriptor().getTriggerReplaceList());
        }
        for (String triggerName : replacedTriggers) {
            triggered.remove(triggerName);
            listener.getLogger().println("Trigger " + triggerName + " was overridden by another trigger and will not send an email.");
        }
        if (emailTriggered && triggered.isEmpty()) {
            listener.getLogger().println("There is a circular trigger replacement with the email triggers.  No email is sent.");
            return false;
        }
        if (triggered.isEmpty()) {
            listener.getLogger().println("No emails were triggered.");
            return true;
        }
        for (String triggerName : triggered.keySet()) {
            listener.getLogger().println("Sending email for trigger: " + triggerName);
            this.sendMail(((EmailTrigger)triggered.get(triggerName)).getEmail(), build, listener);
        }
        return true;
    }

    private boolean sendMail(EmailType mailType, AbstractBuild<?, ?> build, BuildListener listener) {
        try {
            MimeMessage msg = this.createMail(mailType, build, listener);
            Address[] allRecipients = msg.getAllRecipients();
            if (allRecipients != null) {
                StringBuilder buf = new StringBuilder("Sending email to:");
                for (Address a : allRecipients) {
                    buf.append(' ').append(a);
                }
                listener.getLogger().println(buf);
                Transport.send((Message)msg);
                if (build.getAction(MailMessageIdAction.class) == null) {
                    build.addAction((Action)new MailMessageIdAction(msg.getMessageID()));
                }
                return true;
            }
            listener.getLogger().println("An attempt to send an e-mail to empty list of recipients, ignored.");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not send email.", e);
            e.printStackTrace(listener.error("Could not send email as a part of the post-build publishers."));
        }
        return false;
    }

    private MimeMessage createMail(EmailType type, AbstractBuild<?, ?> build, BuildListener listener) throws MessagingException, IOException, InterruptedException {
        MailMessageIdAction b;
        MimeMessage msg;
        boolean overrideGlobalSettings = DESCRIPTOR.getOverrideGlobalSettings();
        if (!overrideGlobalSettings) {
            msg = new MimeMessage(Mailer.descriptor().createSession());
            msg.setFrom((Address)new InternetAddress(Mailer.descriptor().getAdminAddress()));
        } else {
            msg = new MimeMessage(DESCRIPTOR.createSession());
            msg.setFrom((Address)new InternetAddress(DESCRIPTOR.getAdminAddress()));
        }
        msg.setSentDate(new Date());
        this.setSubject(type, build, msg);
        this.setContent(type, build, msg);
        EnvVars env = build.getEnvironment((TaskListener)listener);
        ArrayList<InternetAddress> recipientAddresses = new ArrayList<InternetAddress>();
        if (type.getSendToRecipientList()) {
            for (String recipient : env.expand(this.recipientList).split("[,\\s]+")) {
                ExtendedEmailPublisher.addAddress(recipientAddresses, (String)recipient, (BuildListener)listener);
            }
        }
        if (type.getSendToDevelopers()) {
            HashSet<User> users;
            if (type.getIncludeCulprits()) {
                users = build.getCulprits();
            } else {
                users = new HashSet<User>();
                for (ChangeLogSet.Entry change : build.getChangeSet()) {
                    users.add(change.getAuthor());
                }
            }
            for (User user : users) {
                String adrs = ((Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)).getAddress();
                if (adrs != null) {
                    ExtendedEmailPublisher.addAddress(recipientAddresses, (String)adrs, (BuildListener)listener);
                    continue;
                }
                listener.getLogger().println("Failed to send e-mail to " + user.getFullName() + " because no e-mail address is known, and no default e-mail domain is configured");
            }
        }
        if (type.getRecipientList() != null && type.getRecipientList().trim().length() > 0) {
            String[] typeRecipients = env.expand(type.getRecipientList()).split("[,\\s]+");
            for (int i = 0; i < typeRecipients.length; ++i) {
                recipientAddresses.add(new InternetAddress(typeRecipients[i]));
            }
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])recipientAddresses.toArray(new InternetAddress[recipientAddresses.size()]));
        AbstractBuild pb = (AbstractBuild)build.getPreviousBuild();
        if (pb != null && (b = (MailMessageIdAction)pb.getAction(MailMessageIdAction.class)) != null && pb.getResult() != Result.SUCCESS) {
            msg.setHeader("In-Reply-To", b.messageId);
            msg.setHeader("References", b.messageId);
        }
        return msg;
    }

    private void setSubject(EmailType type, AbstractBuild<?, ?> build, MimeMessage msg) throws MessagingException {
        String subject = new ContentBuilder().transformText(type.getSubject(), this, type, build);
        msg.setSubject(subject, "utf-8");
    }

    private void setContent(EmailType type, AbstractBuild<?, ?> build, MimeMessage msg) throws MessagingException {
        String text = new ContentBuilder().transformText(type.getBody(), this, type, build);
        String messageContentType = this.contentType;
        if ((messageContentType == null || "default".equals(messageContentType)) && (messageContentType = DESCRIPTOR.getDefaultContentType()) == null) {
            messageContentType = "text/plain";
        }
        messageContentType = messageContentType + "; charset=utf-8";
        msg.setContent((Object)text, messageContentType);
    }

    private static void addAddress(List<InternetAddress> addresses, String address, BuildListener listener) {
        try {
            addresses.add(new InternetAddress(address));
        }
        catch (AddressException ae) {
            LOGGER.log(Level.WARNING, "Could not create email address.", ae);
            listener.getLogger().println("Failed to create e-mail address for " + address);
        }
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    static /* synthetic */ List access$002(ExtendedEmailPublisher x0, List x1) {
        x0.configuredTriggers = x1;
        return x0.configuredTriggers;
    }

    static /* synthetic */ Map access$100() {
        return EMAIL_TRIGGER_TYPE_MAP;
    }

    static /* synthetic */ List access$000(ExtendedEmailPublisher x0) {
        return x0.configuredTriggers;
    }
}

