/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildLogContent
implements EmailContent {
    private static final Logger LOGGER = Logger.getLogger(Mailer.class.getName());
    private static final String TOKEN = "BUILD_LOG";
    private static final String MAX_LINES_ARG_NAME = "maxLines";
    private static final int MAX_LINES_DEFAULT_VALUE = 250;

    public String getToken() {
        return TOKEN;
    }

    public List<String> getArguments() {
        return Collections.singletonList(MAX_LINES_ARG_NAME);
    }

    public String getHelpText() {
        return "Displays the end of the build log.\n<ul>\n<li><i>maxLines</i> - display at most this many lines of the log.<br>\nDefaults to 250.\n</ul>\n";
    }

    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType emailType, Map<String, ?> args) {
        StringBuffer buffer = new StringBuffer();
        int maxLines = Math.max(EmailContent.Args.get(args, (String)MAX_LINES_ARG_NAME, (int)250), 1);
        try {
            List lines = build.getLog(maxLines);
            for (String line : lines) {
                buffer.append(line);
                buffer.append('\n');
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        return buffer.toString();
    }

    public boolean hasNestedContent() {
        return false;
    }
}

