/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.tasks.Mailer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildLogRegexContent
implements EmailContent {
    private static final Logger LOGGER = Logger.getLogger(Mailer.class.getName());
    private static final String TOKEN = "BUILD_LOG_REGEX";
    private static final String REGEX_ARG_NAME = "regex";
    private static final String REGEX_DEFAULT_VALUE = "(?i)\\b(error|exception|fatal|fail(ed|ure)|un(defined|resolved))\\b";
    private static final String LINES_BEFORE_ARG_NAME = "linesBefore";
    private static final int LINES_BEFORE_DEFAULT_VALUE = 0;
    private static final String LINES_AFTER_ARG_NAME = "linesAfter";
    private static final int LINES_AFTER_DEFAULT_VALUE = 0;
    private static final String MAX_MATCHES_ARG_NAME = "maxMatches";
    private static final int MAX_MATCHES_DEFAULT_VALUE = 0;
    private static final String SHOW_TRUNCATED_LINES_ARG_NAME = "showTruncatedLines";
    private static final boolean SHOW_TRUNCATED_LINES_DEFAULT_VALUE = true;

    public String getToken() {
        return TOKEN;
    }

    public List<String> getArguments() {
        return Arrays.asList(REGEX_ARG_NAME, LINES_BEFORE_ARG_NAME, LINES_AFTER_ARG_NAME, MAX_MATCHES_ARG_NAME, SHOW_TRUNCATED_LINES_ARG_NAME);
    }

    public String getHelpText() {
        return "Displays lines from the build log that match the regular expression.\n<ul\n<li><i>regex</i> - Lines that match this regular expression are included. See also <i>java.util.regex.Pattern</i><br>\nDefaults to \"(?i)\\b(error|exception|fatal|fail(ed|ure)|un(defined|resolved))\\b\".\n<li><i>linesBefore</i> - The number of lines to include before the matching line. Lines that overlap with another match or <i>linesAfter</i> are only included once.<br>\nDefaults to 0.\n<li><i>linesAfter</i> - The number of lines to include after the matching line. Lines that overlap with another match or <i>linesBefore</i> are only included once.<br>\nDefaults to 0.\n<li><i>maxMatches</i> - The maximum number of matches to include. If 0, all matches will be included.<br>\nDefaults to 0.\n<li><i>showTruncatedLines</i> - If <i>true</i>, include <tt>[...truncated ### lines...]</tt> lines.<br>\nDefaults to true.\n</ul>\n";
    }

    private void append(StringBuffer buffer, String line) {
        buffer.append(line);
        buffer.append('\n');
    }

    private void appendLinesTruncated(StringBuffer buffer, int numLinesTruncated) {
        this.append(buffer, "[...truncated " + numLinesTruncated + " lines...]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType emailType, Map<String, ?> args) {
        String regex = EmailContent.Args.get(args, (String)REGEX_ARG_NAME, (String)REGEX_DEFAULT_VALUE);
        int contextLinesBefore = EmailContent.Args.get(args, (String)LINES_BEFORE_ARG_NAME, (int)0);
        int contextLinesAfter = EmailContent.Args.get(args, (String)LINES_AFTER_ARG_NAME, (int)0);
        int maxMatches = EmailContent.Args.get(args, (String)MAX_MATCHES_ARG_NAME, (int)0);
        boolean showTruncatedLines = EmailContent.Args.get(args, (String)SHOW_TRUNCATED_LINES_ARG_NAME, (boolean)true);
        Pattern pattern = Pattern.compile(regex);
        StringBuffer buffer = new StringBuffer();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(build.getLogFile()));
            try {
                int numLinesTruncated = 0;
                int numMatches = 0;
                int numLinesStillNeeded = 0;
                LinkedList<String> linesBefore = new LinkedList<String>();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    while (linesBefore.size() > contextLinesBefore) {
                        linesBefore.remove();
                        ++numLinesTruncated;
                    }
                    if (pattern.matcher(line).find()) {
                        if (showTruncatedLines && numLinesTruncated > 0) {
                            this.appendLinesTruncated(buffer, numLinesTruncated);
                            numLinesTruncated = 0;
                        }
                        while (linesBefore.size() > 0) {
                            this.append(buffer, (String)linesBefore.remove());
                        }
                        this.append(buffer, line);
                        ++numMatches;
                        numLinesStillNeeded = contextLinesAfter;
                    } else if (numLinesStillNeeded > 0) {
                        this.append(buffer, line);
                        --numLinesStillNeeded;
                    } else {
                        linesBefore.offer(line);
                    }
                    if (maxMatches == 0 || numMatches < maxMatches || numLinesStillNeeded != 0) continue;
                }
                if (showTruncatedLines) {
                    while (linesBefore.size() > 0) {
                        linesBefore.remove();
                        ++numLinesTruncated;
                    }
                    if (line != null) {
                        while ((line = reader.readLine()) != null) {
                            ++numLinesTruncated;
                        }
                    }
                    if (numLinesTruncated > 0) {
                        this.appendLinesTruncated(buffer, numLinesTruncated);
                    }
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        return buffer.toString();
    }

    public boolean hasNestedContent() {
        return false;
    }
}

