/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.Util;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.plugins.emailext.plugins.content.ChangesSinceLastBuildContent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangesSinceLastSuccessfulBuildContent
implements EmailContent {
    private static final String TOKEN = "CHANGES_SINCE_LAST_SUCCESS";
    private static final String REVERSE_ARG_NAME = "reverse";
    private static final boolean REVERSE_DEFAULT_VALUE = false;
    private static final String FORMAT_ARG_NAME = "format";
    private static final String FORMAT_DEFAULT_VALUE = "Changes for Build #%n\\n%c\\n";
    private static final String SHOW_PATHS_ARG_NAME = "showPaths";
    private static final String CHANGES_FORMAT_ARG_NAME = "changesFormat";
    private static final String PATH_FORMAT_ARG_NAME = "pathFormat";

    @Override
    public String getToken() {
        return TOKEN;
    }

    @Override
    public List<String> getArguments() {
        return Arrays.asList(REVERSE_ARG_NAME, FORMAT_ARG_NAME, SHOW_PATHS_ARG_NAME, CHANGES_FORMAT_ARG_NAME, PATH_FORMAT_ARG_NAME);
    }

    @Override
    public String getHelpText() {
        return "Displays the changes since the last successful build.\n<ul>\n<li><i>reverse</i> - indicates that most recent builds should be at the top.<br>\nDefaults to false.\n<li><i>format</i> - for each build listed, a string containing %X, where %X is one of %c for changes, or %n for build number.<br>\nDefaults to \"Changes for Build #%n\\n%c\\n\".\n<li><i>showPaths</i>, <i>changesFormat</i>, <i>pathFormat</i> - defined as <i>showPaths</i>, <i>format</i>, and <i>pathFormat</i> from ${CHANGES}, repectively.\n</ul>\n";
    }

    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType emailType, Map<String, ?> args) {
        AbstractBuild endBuild;
        AbstractBuild startBuild;
        if (build.getPreviousBuild() == null) {
            return "";
        }
        AbstractBuild firstIncludedBuild = build;
        AbstractBuild prev = (AbstractBuild)firstIncludedBuild.getPreviousBuild();
        while (prev != null && prev.getResult() != Result.SUCCESS) {
            firstIncludedBuild = prev;
            prev = (AbstractBuild)firstIncludedBuild.getPreviousBuild();
        }
        String formatString = EmailContent.Args.get(args, FORMAT_ARG_NAME, FORMAT_DEFAULT_VALUE);
        boolean reverseOrder = EmailContent.Args.get(args, REVERSE_ARG_NAME, false);
        HashMap<String, Object> childArgs = new HashMap<String, Object>();
        childArgs.put(FORMAT_ARG_NAME, args.get(CHANGES_FORMAT_ARG_NAME));
        childArgs.put(PATH_FORMAT_ARG_NAME, args.get(PATH_FORMAT_ARG_NAME));
        StringBuffer sb = new StringBuffer();
        if (reverseOrder) {
            startBuild = build;
            endBuild = firstIncludedBuild;
        } else {
            startBuild = firstIncludedBuild;
            endBuild = build;
        }
        AbstractBuild currentBuild = null;
        while (currentBuild != endBuild) {
            currentBuild = currentBuild == null ? startBuild : (reverseOrder ? (AbstractBuild)currentBuild.getPreviousBuild() : (AbstractBuild)currentBuild.getNextBuild());
            this.appendBuild(sb, formatString, publisher, emailType, currentBuild, childArgs);
        }
        return sb.toString();
    }

    private <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> void appendBuild(StringBuffer buf, String formatString, final ExtendedEmailPublisher publisher, final EmailType emailType, final AbstractBuild<P, B> currentBuild, final Map<String, Object> childArgs) {
        final ChangesSinceLastBuildContent changes = new ChangesSinceLastBuildContent();
        Util.printf(buf, formatString, new Util.PrintfSpec(){

            public boolean printSpec(StringBuffer buf, char formatChar) {
                switch (formatChar) {
                    case 'c': {
                        buf.append(changes.getContent(currentBuild, publisher, emailType, childArgs));
                        return true;
                    }
                    case 'n': {
                        buf.append(currentBuild.getNumber());
                        return true;
                    }
                }
                return false;
            }
        });
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }
}

