/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.execution.exclusive;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.plugins.execution.exclusive.ExclusiveBuildWrapper;
import hudson.tasks.BuildWrapper;
import java.io.PrintStream;
import org.kohsuke.stapler.DataBoundConstructor;

public class ExclusiveBuildWrapper
extends BuildWrapper {
    @DataBoundConstructor
    public ExclusiveBuildWrapper() {
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        String nodeName = Computer.currentComputer().getDisplayName();
        logger.println("[ExclusiveBuildWrapper] Executing on " + nodeName);
        logger.println("[ExclusiveBuildWrapper] Putting hudson in shutdown mode...");
        Hudson.getInstance().doQuietDown();
        boolean ready = false;
        while (!ready) {
            ready = true;
            for (Computer computer : Hudson.getInstance().getComputers()) {
                if ((nodeName.equals(computer.getDisplayName()) || computer.isIdle()) && (!nodeName.equals(computer.getDisplayName()) || computer.countBusy() == 1)) continue;
                ready = false;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {}
        }
        logger.println("[ExclusiveBuildWrapper] Only this job is running; starting execution...");
        return new ExclusiveEnvironment(this, listener);
    }
}

