/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.execution.exclusive;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.plugins.execution.exclusive.Messages;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class ExclusiveBuildWrapper
extends BuildWrapper {
    @DataBoundConstructor
    public ExclusiveBuildWrapper() {
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        String nodeName = Computer.currentComputer().getDisplayName();
        logger.println("[ExclusiveBuildWrapper] Executing on " + nodeName);
        logger.println("[ExclusiveBuildWrapper] Putting hudson in shutdown mode...");
        try {
            Hudson.getInstance().doQuietDown();
        }
        catch (IOException ex) {
            Logger.getLogger(ExclusiveBuildWrapper.class.getName()).log(Level.SEVERE, null, ex);
        }
        boolean ready = false;
        while (!ready) {
            ready = true;
            for (Computer computer : Hudson.getInstance().getComputers()) {
                if ((nodeName.equals(computer.getDisplayName()) || computer.isIdle()) && (!nodeName.equals(computer.getDisplayName()) || computer.countBusy() == 1)) continue;
                ready = false;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {}
        }
        logger.println("[ExclusiveBuildWrapper] Only this job is running; starting execution...");
        return new ExclusiveEnvironment(listener);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return Messages.ExclusiveBuildWrapper_DisplayName();
        }

        public boolean isApplicable(AbstractProject item) {
            return true;
        }
    }

    class ExclusiveEnvironment
    extends BuildWrapper.Environment {
        private BuildListener listener;

        public ExclusiveEnvironment(BuildListener listener) {
            super((BuildWrapper)ExclusiveBuildWrapper.this);
            this.listener = listener;
        }

        public boolean tearDown(AbstractBuild build, BuildListener listener) {
            PrintStream logger = listener.getLogger();
            logger.println("[ExclusiveBuildWrapper] Canceling hudson shutdown mode...");
            Hudson.getInstance().doCancelQuietDown();
            return true;
        }
    }
}

