/*
 * Decompiled with CFR 0.152.
 */
package com.cwctravel.hudson.plugins.extended_choice_parameter;

import com.cwctravel.hudson.plugins.extended_choice_parameter.ExtendedChoiceParameterValue;
import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedChoiceParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = -2946187268529865645L;
    public static final String PARAMETER_TYPE_SINGLE_SELECT = "PT_SINGLE_SELECT";
    public static final String PARAMETER_TYPE_MULTI_SELECT = "PT_MULTI_SELECT";
    private String type;
    private String value;
    private String propertyFile;
    private String propertyKey;
    private String defaultValue;
    private String defaultPropertyFile;
    private String defaultPropertyKey;
    private Map<String, Boolean> defaultValueMap;

    @DataBoundConstructor
    public ExtendedChoiceParameterDefinition(String name, String type, String value, String propertyFile, String propertyKey, String defaultValue, String defaultPropertyFile, String defaultPropertyKey, String description) {
        super(name, description);
        this.type = type;
        this.propertyFile = propertyFile;
        this.propertyKey = propertyKey;
        this.defaultPropertyFile = defaultPropertyFile;
        this.defaultPropertyKey = defaultPropertyKey;
        this.value = this.computeValue(value, propertyFile, propertyKey);
        this.defaultValue = this.computeValue(defaultValue, defaultPropertyFile, defaultPropertyKey);
        this.computeDefaultValueMap();
    }

    private void computeDefaultValueMap() {
        if (!StringUtils.isBlank((String)this.defaultValue)) {
            String[] defaultValues;
            this.defaultValueMap = new HashMap<String, Boolean>();
            for (String value : defaultValues = StringUtils.split((String)this.defaultValue, (char)',')) {
                this.defaultValueMap.put(value, true);
            }
        }
    }

    public ParameterValue createValue(StaplerRequest request) {
        String[] value = request.getParameterValues(this.getName());
        if (value == null) {
            return this.getDefaultParameterValue();
        }
        return null;
    }

    public ParameterValue createValue(StaplerRequest request, JSONObject jO) {
        Object value = jO.get("value");
        String strValue = "";
        if (value instanceof String) {
            strValue = (String)value;
        } else if (value instanceof JSONArray) {
            JSONArray jsonValues = (JSONArray)value;
            for (int i = 0; i < jsonValues.size(); ++i) {
                strValue = strValue + jsonValues.getString(i);
                if (i >= jsonValues.size() - 1) continue;
                strValue = strValue + ",";
            }
        }
        strValue = "\"" + strValue + "\"";
        ExtendedChoiceParameterValue extendedChoiceParameterValue = new ExtendedChoiceParameterValue(jO.getString("name"), strValue);
        return extendedChoiceParameterValue;
    }

    public ParameterValue getDefaultParameterValue() {
        String defaultValue = this.getDefaultValue();
        if (!StringUtils.isBlank((String)defaultValue)) {
            defaultValue = "\"" + defaultValue + "\"";
            return new ExtendedChoiceParameterValue(this.getName(), defaultValue);
        }
        return super.getDefaultParameterValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String computeValue(String value, String propertyFile, String propertyKey) {
        block6: {
            if (!StringUtils.isBlank((String)propertyFile) && !StringUtils.isBlank((String)propertyKey)) {
                String string;
                FileInputStream fIS = null;
                try {
                    fIS = new FileInputStream(new File(propertyFile));
                    Properties properties = new Properties();
                    properties.load(fIS);
                    string = properties.getProperty(propertyKey);
                }
                catch (Exception e) {
                    IOUtils.closeQuietly(fIS);
                    break block6;
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fIS);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)fIS);
                return string;
            }
            if (!StringUtils.isBlank((String)value)) {
                return value;
            }
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDefaultValue() {
        return this.computeValue(this.defaultValue, this.defaultPropertyFile, this.defaultPropertyKey);
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public void setPropertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
    }

    public String getDefaultPropertyKey() {
        return this.defaultPropertyKey;
    }

    public void setDefaultPropertyKey(String defaultPropertyKey) {
        this.defaultPropertyKey = defaultPropertyKey;
    }

    public String getValue() {
        return this.computeValue(this.value, this.propertyFile, this.propertyKey);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public void setPropertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public String getDefaultPropertyFile() {
        return this.defaultPropertyFile;
    }

    public void setDefaultPropertyFile(String defaultPropertyFile) {
        this.defaultPropertyFile = defaultPropertyFile;
    }

    public Map<String, Boolean> getDefaultValueMap() {
        return this.defaultValueMap;
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Extended Choice Parameter";
        }
    }
}

