// CHECKSTYLE:OFF

package hudson.plugins.filesfoundtrigger;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Started due to files found in "{0}" matching pattern "{1}"
     * 
     */
    public static String Cause(Object arg1, Object arg2) {
        return holder.format("Cause", arg1, arg2);
    }

    /**
     * Started due to files found in "{0}" matching pattern "{1}"
     * 
     */
    public static Localizable _Cause(Object arg1, Object arg2) {
        return new Localizable(holder, "Cause", arg1, arg2);
    }

    /**
     * Started due to files found in "{0}" matching pattern "{1}" but not "{2}"
     * 
     */
    public static String CauseWithIgnoredFiles(Object arg1, Object arg2, Object arg3) {
        return holder.format("CauseWithIgnoredFiles", arg1, arg2, arg3);
    }

    /**
     * Started due to files found in "{0}" matching pattern "{1}" but not "{2}"
     * 
     */
    public static Localizable _CauseWithIgnoredFiles(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "CauseWithIgnoredFiles", arg1, arg2, arg3);
    }

    /**
     * Build when certain files are found
     * 
     */
    public static String DisplayName() {
        return holder.format("DisplayName");
    }

    /**
     * Build when certain files are found
     * 
     */
    public static Localizable _DisplayName() {
        return new Localizable(holder, "DisplayName");
    }

}
