/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesfoundtrigger;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.Util;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.plugins.filesfoundtrigger.FilesFoundTriggerCause;
import hudson.plugins.filesfoundtrigger.Messages;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.io.File;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesFoundTrigger
extends Trigger<BuildableItem> {
    private final String directory;
    private final String files;
    private final String ignoredFiles;

    @DataBoundConstructor
    public FilesFoundTrigger(String timerSpec, String directory, String files, String ignoredFiles) throws ANTLRException {
        super(timerSpec);
        this.directory = Util.fixEmptyAndTrim((String)directory);
        this.files = Util.fixEmptyAndTrim((String)files);
        this.ignoredFiles = Util.fixEmptyAndTrim((String)ignoredFiles);
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFiles() {
        return this.files;
    }

    public String getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public void run() {
        if (this.filesFound()) {
            ((BuildableItem)this.job).scheduleBuild(0, (Cause)new FilesFoundTriggerCause(this));
        }
    }

    private boolean filesFound() {
        if (this.directory == null || this.files == null) {
            return false;
        }
        FileSet fileSet = Util.createFileSet((File)new File(this.directory), (String)this.files, (String)this.ignoredFiles);
        return fileSet.size() > 0;
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return item instanceof BuildableItem;
        }

        public String getDisplayName() {
            return Messages.DisplayName();
        }
    }
}

