/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesfoundtrigger;

import antlr.ANTLRException;
import hudson.Util;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.plugins.filesfoundtrigger.FilesFoundTriggerCause;
import hudson.triggers.Trigger;
import java.io.File;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilesFoundTrigger
extends Trigger<BuildableItem> {
    private final String directory;
    private final String files;
    private final String ignoredFiles;

    @DataBoundConstructor
    public FilesFoundTrigger(String timerSpec, String directory, String files, String ignoredFiles) throws ANTLRException {
        super(timerSpec);
        this.directory = directory.trim();
        this.files = files.trim();
        this.ignoredFiles = ignoredFiles.trim();
    }

    private FilesFoundTrigger() throws ANTLRException {
        this.directory = "";
        this.files = "";
        this.ignoredFiles = "";
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFiles() {
        return this.files;
    }

    public String getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public void run() {
        if (this.filesFound()) {
            ((BuildableItem)this.job).scheduleBuild(0, (Cause)new FilesFoundTriggerCause(this));
        }
    }

    boolean filesFound() {
        if (this.directoryFound() && this.filesSpecified()) {
            FileSet fileSet = Util.createFileSet((File)new File(this.directory), (String)this.files, (String)this.ignoredFiles);
            fileSet.setDefaultexcludes(false);
            return fileSet.size() > 0;
        }
        return false;
    }

    private boolean directorySpecified() {
        return this.directory.length() != 0;
    }

    private boolean filesSpecified() {
        return this.files.length() != 0;
    }

    private boolean directoryFound() {
        return this.directorySpecified() && new File(this.directory).isDirectory();
    }

    static /* synthetic */ boolean access$000(FilesFoundTrigger x0) {
        return x0.directorySpecified();
    }

    static /* synthetic */ boolean access$100(FilesFoundTrigger x0) {
        return x0.filesSpecified();
    }

    static /* synthetic */ boolean access$200(FilesFoundTrigger x0) {
        return x0.directoryFound();
    }
}

