/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesfoundtrigger;

import antlr.ANTLRException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.mapper.Mapper;
import hudson.Util;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.plugins.filesfoundtrigger.FilesFoundTriggerCause;
import hudson.plugins.filesfoundtrigger.Messages;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import hudson.util.RobustReflectionConverter;
import java.io.File;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilesFoundTrigger
extends Trigger<BuildableItem> {
    private final String directory;
    private final String files;
    private final String ignoredFiles;

    @DataBoundConstructor
    public FilesFoundTrigger(String timerSpec, String directory, String files, String ignoredFiles) throws ANTLRException {
        super(timerSpec);
        this.directory = directory.trim();
        this.files = files.trim();
        this.ignoredFiles = ignoredFiles.trim();
    }

    private FilesFoundTrigger() throws ANTLRException {
        this.directory = "";
        this.files = "";
        this.ignoredFiles = "";
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFiles() {
        return this.files;
    }

    public String getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public void run() {
        if (this.filesFound()) {
            ((BuildableItem)this.job).scheduleBuild(0, (Cause)new FilesFoundTriggerCause(this));
        }
    }

    boolean filesFound() {
        if (this.directoryFound() && this.filesSpecified()) {
            FileSet fileSet = Util.createFileSet((File)new File(this.directory), (String)this.files, (String)this.ignoredFiles);
            fileSet.setDefaultexcludes(false);
            return fileSet.size() > 0;
        }
        return false;
    }

    private boolean directorySpecified() {
        return this.directory.length() != 0;
    }

    private boolean filesSpecified() {
        return this.files.length() != 0;
    }

    private boolean directoryFound() {
        return this.directorySpecified() && new File(this.directory).isDirectory();
    }

    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return item instanceof BuildableItem;
        }

        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public FormValidation doTestConfiguration(@QueryParameter(value="directory") String directory, @QueryParameter(value="files") String files, @QueryParameter(value="ignoredFiles") String ignoredFiles) {
            FilesFoundTrigger trigger;
            try {
                trigger = new FilesFoundTrigger("", directory, files, ignoredFiles);
            }
            catch (ANTLRException ex) {
                throw new RuntimeException(ex);
            }
            if (!trigger.directorySpecified()) {
                return FormValidation.error((String)Messages.DirectoryNotSpecified());
            }
            if (!trigger.filesSpecified()) {
                return FormValidation.error((String)Messages.FilesNotSpecified());
            }
            if (!trigger.directoryFound()) {
                return FormValidation.warning((String)Messages.DirectoryNotFound());
            }
            if (!trigger.filesFound()) {
                return FormValidation.ok((String)Messages.FilesNotFound());
            }
            return FormValidation.ok((String)Messages.FilesFound());
        }
    }

    public static class ConverterImpl
    extends RobustReflectionConverter {
        public ConverterImpl(Mapper mapper) {
            super(mapper, (ReflectionProvider)new PureJavaReflectionProvider());
        }
    }
}

