/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesfoundtrigger;

import antlr.ANTLRException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.mapper.Mapper;
import hudson.model.Cause;
import hudson.plugins.filesfoundtrigger.FilesFoundTrigger;
import hudson.plugins.filesfoundtrigger.Messages;
import hudson.util.RobustReflectionConverter;
import java.util.Arrays;
import org.apache.commons.lang.ObjectUtils;
import org.kohsuke.stapler.export.Exported;

public final class FilesFoundTriggerCause
extends Cause {
    private final String directory;
    private final String files;
    private final String ignoredFiles;

    FilesFoundTriggerCause(FilesFoundTrigger trigger) {
        this.directory = trigger.getDirectory();
        this.files = trigger.getFiles();
        this.ignoredFiles = trigger.getIgnoredFiles();
    }

    private FilesFoundTriggerCause() throws ANTLRException {
        this.directory = "";
        this.files = "";
        this.ignoredFiles = "";
    }

    @Exported(visibility=3)
    public String getDirectory() {
        return this.directory;
    }

    @Exported(visibility=3)
    public String getFiles() {
        return this.files;
    }

    @Exported(visibility=3)
    public String getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public String getShortDescription() {
        return this.ignoredFiles.length() == 0 ? Messages.Cause(this.directory, this.files) : Messages.CauseWithIgnoredFiles(this.directory, this.files, this.ignoredFiles);
    }

    public int hashCode() {
        return Arrays.hashCode(new String[]{this.directory, this.files, this.ignoredFiles});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FilesFoundTriggerCause) {
            FilesFoundTriggerCause other = (FilesFoundTriggerCause)((Object)obj);
            return ObjectUtils.equals((Object)this.directory, (Object)other.directory) && ObjectUtils.equals((Object)this.files, (Object)other.files) && ObjectUtils.equals((Object)this.ignoredFiles, (Object)other.ignoredFiles);
        }
        return false;
    }

    public static class ConverterImpl
    extends RobustReflectionConverter {
        public ConverterImpl(Mapper mapper) {
            super(mapper, (ReflectionProvider)new PureJavaReflectionProvider());
        }
    }
}

