// CHECKSTYLE:OFF

package hudson.plugins.filesfoundtrigger;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Started due to files found in "{0}" matching pattern "{1}"
     * 
     */
    public static String Cause(Object arg1, Object arg2) {
        return holder.format("Cause", arg1, arg2);
    }

    /**
     * Started due to files found in "{0}" matching pattern "{1}"
     * 
     */
    public static Localizable _Cause(Object arg1, Object arg2) {
        return new Localizable(holder, "Cause", arg1, arg2);
    }

    /**
     * Directory not specified.
     * 
     */
    public static String DirectoryNotSpecified() {
        return holder.format("DirectoryNotSpecified");
    }

    /**
     * Directory not specified.
     * 
     */
    public static Localizable _DirectoryNotSpecified() {
        return new Localizable(holder, "DirectoryNotSpecified");
    }

    /**
     * Started due to files found in "{0}" matching pattern "{1}" but not "{2}"
     * 
     */
    public static String CauseWithIgnoredFiles(Object arg1, Object arg2, Object arg3) {
        return holder.format("CauseWithIgnoredFiles", arg1, arg2, arg3);
    }

    /**
     * Started due to files found in "{0}" matching pattern "{1}" but not "{2}"
     * 
     */
    public static Localizable _CauseWithIgnoredFiles(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "CauseWithIgnoredFiles", arg1, arg2, arg3);
    }

    /**
     * Files not specified.
     * 
     */
    public static String FilesNotSpecified() {
        return holder.format("FilesNotSpecified");
    }

    /**
     * Files not specified.
     * 
     */
    public static Localizable _FilesNotSpecified() {
        return new Localizable(holder, "FilesNotSpecified");
    }

    /**
     * Build when certain files are found
     * 
     */
    public static String DisplayName() {
        return holder.format("DisplayName");
    }

    /**
     * Build when certain files are found
     * 
     */
    public static Localizable _DisplayName() {
        return new Localizable(holder, "DisplayName");
    }

    /**
     * Directory not found.
     * 
     */
    public static String DirectoryNotFound() {
        return holder.format("DirectoryNotFound");
    }

    /**
     * Directory not found.
     * 
     */
    public static Localizable _DirectoryNotFound() {
        return new Localizable(holder, "DirectoryNotFound");
    }

    /**
     * Files not found.
     * 
     */
    public static String FilesNotFound() {
        return holder.format("FilesNotFound");
    }

    /**
     * Files not found.
     * 
     */
    public static Localizable _FilesNotFound() {
        return new Localizable(holder, "FilesNotFound");
    }

    /**
     * Files found.
     * 
     */
    public static String FilesFound() {
        return holder.format("FilesFound");
    }

    /**
     * Files found.
     * 
     */
    public static Localizable _FilesFound() {
        return new Localizable(holder, "FilesFound");
    }

}
