/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesfoundtrigger;

import hudson.model.Cause;
import hudson.plugins.filesfoundtrigger.FilesFoundTrigger;
import hudson.plugins.filesfoundtrigger.Messages;
import hudson.plugins.filesfoundtrigger.xstream.DefaultProvider;
import hudson.plugins.filesfoundtrigger.xstream.XStreamDefault;
import java.util.Arrays;
import org.apache.commons.lang.ObjectUtils;
import org.kohsuke.stapler.export.Exported;

public class FilesFoundTriggerCause
extends Cause {
    @XStreamDefault(value=DefaultProvider.EmptyString.class)
    private final String directory;
    @XStreamDefault(value=DefaultProvider.EmptyString.class)
    private final String files;
    @XStreamDefault(value=DefaultProvider.EmptyString.class)
    private final String ignoredFiles;

    FilesFoundTriggerCause(FilesFoundTrigger trigger) {
        this.directory = trigger.getDirectory();
        this.files = trigger.getFiles();
        this.ignoredFiles = trigger.getIgnoredFiles();
    }

    @Exported(visibility=3)
    public String getDirectory() {
        return this.directory;
    }

    @Exported(visibility=3)
    public String getFiles() {
        return this.files;
    }

    @Exported(visibility=3)
    public String getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public String getShortDescription() {
        return this.ignoredFiles.isEmpty() ? Messages.Cause((Object)this.directory, (Object)this.files) : Messages.CauseWithIgnoredFiles((Object)this.directory, (Object)this.files, (Object)this.ignoredFiles);
    }

    public int hashCode() {
        return Arrays.hashCode(new String[]{this.directory, this.files, this.ignoredFiles});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FilesFoundTriggerCause) {
            FilesFoundTriggerCause other = (FilesFoundTriggerCause)obj;
            return ObjectUtils.equals((Object)this.directory, (Object)other.directory) && ObjectUtils.equals((Object)this.files, (Object)other.files) && ObjectUtils.equals((Object)this.ignoredFiles, (Object)other.ignoredFiles);
        }
        return false;
    }
}

