/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.filesfoundtrigger;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.Util;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.plugins.filesfoundtrigger.FilesFoundTriggerCause;
import hudson.plugins.filesfoundtrigger.Messages;
import hudson.plugins.filesfoundtrigger.xstream.DefaultProvider;
import hudson.plugins.filesfoundtrigger.xstream.DefaultingConverter;
import hudson.plugins.filesfoundtrigger.xstream.XStreamDefault;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import hudson.util.XStream2;
import java.io.File;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesFoundTrigger
extends Trigger<BuildableItem> {
    @XStreamDefault(value=DefaultProvider.EmptyString.class)
    private final String directory;
    @XStreamDefault(value=DefaultProvider.EmptyString.class)
    private final String files;
    @XStreamDefault(value=DefaultProvider.EmptyString.class)
    private final String ignoredFiles;

    @DataBoundConstructor
    public FilesFoundTrigger(String timerSpec, String directory, String files, String ignoredFiles) throws ANTLRException {
        super(timerSpec);
        this.directory = directory.trim();
        this.files = files.trim();
        this.ignoredFiles = ignoredFiles.trim();
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFiles() {
        return this.files;
    }

    public String getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public void run() {
        if (this.filesFound()) {
            ((BuildableItem)this.job).scheduleBuild(0, (Cause)new FilesFoundTriggerCause(this));
        }
    }

    boolean filesFound() {
        if (this.directoryFound() && this.filesSpecified()) {
            FileSet fileSet = Util.createFileSet((File)new File(this.directory), (String)this.files, (String)this.ignoredFiles);
            fileSet.setDefaultexcludes(false);
            return fileSet.size() > 0;
        }
        return false;
    }

    private boolean directorySpecified() {
        return !this.directory.isEmpty();
    }

    private boolean filesSpecified() {
        return !this.files.isEmpty();
    }

    private boolean directoryFound() {
        return this.directorySpecified() && new File(this.directory).isDirectory();
    }

    public static class ConverterImpl
    extends DefaultingConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return item instanceof BuildableItem;
        }

        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public FormValidation doTestConfiguration(@QueryParameter(value="directory") String directory, @QueryParameter(value="files") String files, @QueryParameter(value="ignoredFiles") String ignoredFiles) {
            FilesFoundTrigger trigger;
            try {
                trigger = new FilesFoundTrigger("", directory, files, ignoredFiles);
            }
            catch (ANTLRException ex) {
                throw new RuntimeException(ex);
            }
            if (!trigger.directorySpecified()) {
                return FormValidation.error((String)Messages.DirectoryNotSpecified());
            }
            if (!trigger.filesSpecified()) {
                return FormValidation.error((String)Messages.FilesNotSpecified());
            }
            if (!trigger.directoryFound()) {
                return FormValidation.warning((String)Messages.DirectoryNotFound());
            }
            if (!trigger.filesFound()) {
                return FormValidation.ok((String)Messages.FilesNotFound());
            }
            return FormValidation.ok((String)Messages.FilesFound());
        }
    }
}

