/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugin.scm.fsscm;

import hudson.model.User;
import hudson.plugin.scm.fsscm.Changelog;
import hudson.plugin.scm.fsscm.ChangelogSet;
import hudson.plugin.scm.fsscm.FolderDiff;
import hudson.scm.ChangeLogSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Changelog
extends ChangeLogSet.Entry {
    private ChangelogSet parent;
    private Date date;
    private List<Path> paths;

    public Changelog() {
    }

    public Changelog(ChangelogSet parent) {
        this.parent = parent;
    }

    public Changelog(ChangelogSet parent, List<FolderDiff.Entry> changes) {
        this.parent = parent;
        this.paths = new ArrayList();
        for (int i = 0; i < changes.size(); ++i) {
            FolderDiff.Entry change = changes.get(i);
            Path path = new Path(this, change);
            this.paths.add(path);
        }
    }

    public Collection getAffectedPaths() {
        return Collections.unmodifiableList(this.paths);
    }

    public String getMsg() {
        if (0 == this.paths.size()) {
            return "No change";
        }
        int add = 0;
        int del = 0;
        int edit = 0;
        for (int i = 0; i < this.paths.size(); ++i) {
            Path path = (Path)this.paths.get(i);
            if ("ADD".equalsIgnoreCase(Path.access$000((Path)path))) {
                ++add;
                continue;
            }
            if ("DELETE".equalsIgnoreCase(Path.access$000((Path)path))) {
                ++del;
                continue;
            }
            ++edit;
        }
        StringBuffer buf = new StringBuffer();
        this.buildMessage(buf, add, "new file", "new files");
        this.buildMessage(buf, edit, "file modified", "files modified");
        this.buildMessage(buf, del, "file deleted", "files deleted");
        return buf.toString();
    }

    private void buildMessage(StringBuffer buf, int count, String singular, String plural) {
        if (count > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(count).append(' ');
            if (count > 1) {
                buf.append(plural);
            } else {
                buf.append(singular);
            }
        }
    }

    public User getAuthor() {
        return User.getUnknown();
    }

    public ChangeLogSet getParent() {
        return this.parent;
    }

    protected void setParent(ChangeLogSet parent) {
        this.parent = (ChangelogSet)parent;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.paths == null ? 0 : ((Object)this.paths).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Changelog other = (Changelog)obj;
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        return !(this.paths == null ? other.paths != null : !((Object)this.paths).equals(other.paths));
    }
}

