/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugin.scm.fsscm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugin.scm.fsscm.ChangelogSet;
import hudson.plugin.scm.fsscm.FSSCM;
import hudson.plugin.scm.fsscm.RemoteCopyDir;
import hudson.plugin.scm.fsscm.RemoteFolderDiff;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DurationFormatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FSSCM
extends SCM {
    private String path;
    private boolean clearWorkspace;
    private boolean filterEnabled;
    private boolean includeFilter;
    private String[] filters;

    public FSSCM(String path, boolean clearWorkspace, boolean filterEnabled, boolean includeFilter, String[] filters) {
        this.path = path;
        this.clearWorkspace = clearWorkspace;
        this.filterEnabled = filterEnabled;
        this.includeFilter = includeFilter;
        if (null != filters) {
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < filters.length; ++i) {
                if (!StringUtils.isNotEmpty((String)filters[i])) continue;
                v.add(filters[i]);
            }
            this.filters = v.toArray(new String[1]);
        } else {
            this.filters = null;
        }
    }

    public String getPath() {
        return this.path;
    }

    public String[] getFilters() {
        return this.filters;
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public boolean isIncludeFilter() {
        return this.includeFilter;
    }

    public boolean isClearWorkspace() {
        return this.clearWorkspace;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        PrintStream log = launcher.getListener().getLogger();
        log.println("FSSCM.checkout " + this.path + " to " + workspace);
        Boolean b = Boolean.TRUE;
        if (this.clearWorkspace) {
            log.println("FSSCM.clearWorkspace...");
            workspace.deleteRecursive();
            b = (Boolean)workspace.act((FilePath.FileCallable)new RemoteCopyDir(this.path));
        } else {
            RemoteFolderDiff.CheckOut callable = new RemoteFolderDiff.CheckOut();
            this.setupRemoteFolderDiff((RemoteFolderDiff)callable, build.getProject());
            List list = (List)workspace.act((FilePath.FileCallable)callable);
            String str = callable.getLog();
            if (str.length() > 0) {
                log.println(str);
            }
            ChangelogSet.XMLSerializer handler = new ChangelogSet.XMLSerializer();
            ChangelogSet changeLogSet = new ChangelogSet(build, list);
            handler.save(changeLogSet, changelogFile);
        }
        log.println("FSSCM.check completed in " + FSSCM.formatDurration((long)(System.currentTimeMillis() - start)));
        return b;
    }

    public ChangeLogParser createChangeLogParser() {
        return new ChangelogSet.XMLSerializer();
    }

    public SCMDescriptor<FSSCM> getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        PrintStream log = launcher.getListener().getLogger();
        log.println("FSSCM.pollChange: " + this.path);
        RemoteFolderDiff.PollChange callable = new RemoteFolderDiff.PollChange();
        this.setupRemoteFolderDiff((RemoteFolderDiff)callable, project);
        boolean changed = (Boolean)workspace.act((FilePath.FileCallable)callable);
        String str = callable.getLog();
        if (str.length() > 0) {
            log.println(str);
        }
        log.println("FSSCM.pollChange return " + changed);
        log.println("FSSCM.poolChange completed in " + FSSCM.formatDurration((long)(System.currentTimeMillis() - start)));
        return changed;
    }

    private void setupRemoteFolderDiff(RemoteFolderDiff diff, AbstractProject project) {
        Run lastBuild = project.getLastBuild();
        if (null == lastBuild) {
            diff.setLastBuildTime(0L);
            diff.setLastSuccessfulBuildTime(0L);
        } else {
            diff.setLastBuildTime(lastBuild.getTimestamp().getTimeInMillis());
            Run lastSuccessfulBuild = project.getLastSuccessfulBuild();
            if (null == lastSuccessfulBuild) {
                diff.setLastSuccessfulBuildTime(-1L);
            } else {
                diff.setLastSuccessfulBuildTime(lastSuccessfulBuild.getTimestamp().getTimeInMillis());
            }
        }
        diff.setSrcPath(this.path);
        if (this.filterEnabled) {
            if (this.includeFilter) {
                diff.setIncludeFilter(this.filters);
            } else {
                diff.setExcludeFilter(this.filters);
            }
        }
    }

    protected static String formatDurration(long diff) {
        if (diff < 60000L) {
            if (diff <= 1L) {
                return diff + " millisecond";
            }
            if (diff < 1000L) {
                return diff + " milliseconds";
            }
            if (diff < 2000L) {
                return (double)diff / 1000.0 + " second";
            }
            return (double)diff / 1000.0 + " seconds";
        }
        return DurationFormatUtils.formatDurationWords((long)diff, (boolean)true, (boolean)true);
    }
}

