/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugin.scm.fsscm;

import hudson.model.AbstractBuild;
import hudson.plugin.scm.fsscm.Changelog;
import hudson.plugin.scm.fsscm.FolderDiff;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.util.XStream2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangelogSet
extends ChangeLogSet {
    private List<Changelog> logs = new ArrayList<Changelog>();

    public ChangelogSet(AbstractBuild build, List<FolderDiff.Entry> changes) {
        super(build);
        this.logs.add(new Changelog(this, changes));
    }

    public String getKind() {
        return "fs_scm";
    }

    public boolean isEmptySet() {
        return this.logs.isEmpty();
    }

    public Iterator<Changelog> iterator() {
        return Collections.unmodifiableList(this.logs).iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.logs == null ? 0 : ((Object)this.logs).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ChangelogSet other = (ChangelogSet)((Object)obj);
        return !(this.logs == null ? other.logs != null : !((Object)this.logs).equals(other.logs));
    }

    public static class XMLSerializer
    extends ChangeLogParser {
        private XStream2 xstream = new XStream2();

        public XMLSerializer() {
            this.xstream.alias("log", ChangelogSet.class);
            this.xstream.aliasField("changelogset", ChangelogSet.class, "changeLogSet");
            this.xstream.alias("changelog", Changelog.class);
            this.xstream.alias("path", Changelog.Path.class);
            this.xstream.omitField(ChangeLogSet.class, "build");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChangelogSet parse(AbstractBuild build, File file) throws FileNotFoundException {
            FileInputStream in = null;
            ChangelogSet out = null;
            try {
                in = new FileInputStream(file);
                out = (ChangelogSet)((Object)this.xstream.fromXML((InputStream)in));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            return out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save(ChangelogSet changeLogSet, File file) throws FileNotFoundException {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                this.xstream.toXML((Object)changeLogSet, (OutputStream)out);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

