/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugin.scm.fsscm;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderDiff {
    private String srcPath;
    private String dstPath;
    private boolean filterEnabled = false;
    private boolean includeFilter;
    private String[] filters;

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public void setDstPath(String dstPath) {
        this.dstPath = dstPath;
    }

    public void setIncludeFilter(String[] filters) {
        this.filterEnabled = true;
        this.includeFilter = true;
        this.filters = filters;
    }

    public void setExcludeFilter(String[] filters) {
        this.filterEnabled = true;
        this.includeFilter = false;
        this.filters = filters;
    }

    public boolean isModifiedSince(long time) {
        return true;
    }

    public List<Entry> getNewOrModifiedFiles(long time, boolean breakOnceFound, boolean testRun) {
        File src = new File(this.srcPath);
        File dst = new File(this.dstPath);
        IOFileFilter dirFilter = HiddenFileFilter.VISIBLE;
        AndFileFilter fileFilter = new AndFileFilter();
        fileFilter.addFileFilter(HiddenFileFilter.VISIBLE);
        if (this.filterEnabled && null != this.filters && this.filters.length > 0) {
            WildcardFileFilter wcf = new WildcardFileFilter(this.filters, IOCase.INSENSITIVE);
            if (this.includeFilter) {
                fileFilter.addFileFilter((IOFileFilter)wcf);
            } else {
                fileFilter.addFileFilter((IOFileFilter)new NotFileFilter((IOFileFilter)wcf));
            }
        }
        Iterator it = FileUtils.iterateFiles((File)src, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        ArrayList<Entry> list = new ArrayList<Entry>();
        while (it.hasNext()) {
            File file = (File)it.next();
            try {
                String relativeName = FolderDiff.getRelativeName(file.getAbsolutePath(), src.getAbsolutePath());
                boolean newOrModified = false;
                File tmp = new File(dst, relativeName);
                if (!tmp.exists()) {
                    newOrModified = true;
                    list.add(new Entry(relativeName, Entry.Type.NEW));
                    this.log("New file: " + relativeName);
                } else if (FileUtils.isFileNewer((File)file, (long)time) || FileUtils.isFileNewer((File)file, (File)tmp)) {
                    newOrModified = true;
                    list.add(new Entry(relativeName, Entry.Type.MODIFIED));
                    this.log("Modified file: " + relativeName);
                }
                if (!newOrModified) continue;
                if (breakOnceFound) {
                    return list;
                }
                if (testRun) continue;
                FileUtils.copyFile((File)file, (File)tmp);
            }
            catch (IOException e) {
                this.log(e);
            }
        }
        return list;
    }

    public List<Entry> getDeletedFiles(long time, boolean breakOnceFound, boolean testRun) {
        File src = new File(this.srcPath);
        File dst = new File(this.dstPath);
        IOFileFilter dirFilter = HiddenFileFilter.VISIBLE;
        AndFileFilter fileFilter = new AndFileFilter();
        fileFilter.addFileFilter((IOFileFilter)new AgeFileFilter(time, true));
        fileFilter.addFileFilter(HiddenFileFilter.VISIBLE);
        if (this.filterEnabled && null != this.filters && this.filters.length > 0) {
            WildcardFileFilter wcf = new WildcardFileFilter(this.filters, IOCase.INSENSITIVE);
            if (this.includeFilter) {
                fileFilter.addFileFilter((IOFileFilter)wcf);
            } else {
                fileFilter.addFileFilter((IOFileFilter)new NotFileFilter((IOFileFilter)wcf));
            }
        }
        Iterator it = FileUtils.iterateFiles((File)dst, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        ArrayList<Entry> list = new ArrayList<Entry>();
        while (it.hasNext()) {
            File file = (File)it.next();
            try {
                String relativeName = FolderDiff.getRelativeName(file.getAbsolutePath(), dst.getAbsolutePath());
                File tmp = new File(src, relativeName);
                if (tmp.exists()) continue;
                this.log("Deleted file: " + relativeName);
                list.add(new Entry(relativeName, Entry.Type.DELETED));
                if (breakOnceFound) {
                    return list;
                }
                if (testRun) continue;
                try {
                    boolean deleted = file.delete();
                    if (deleted) continue;
                    this.log("file.delete() failed: " + file.getAbsolutePath());
                }
                catch (SecurityException e) {
                    this.log("Can't delete " + file.getAbsolutePath(), e);
                }
            }
            catch (IOException e) {
                this.log(e);
            }
        }
        return list;
    }

    protected void log(Exception e) {
        this.log(FolderDiff.stackTraceToString(e));
    }

    protected void log(String msg, Exception e) {
        this.log(msg + "\n" + FolderDiff.stackTraceToString(e));
    }

    protected void log(String msg) {
        System.out.println(msg);
    }

    public static String stackTraceToString(Exception e) {
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        e.printStackTrace(writer);
        writer.flush();
        buf.flush();
        return buf.toString();
    }

    public static String getRelativeName(String fileName, String folderName) throws IOException {
        int x;
        String sep = File.separator;
        if (!folderName.endsWith(sep)) {
            folderName = folderName + sep;
        }
        if (0 != (x = fileName.indexOf(folderName))) {
            throw new IOException(fileName + " is not inside " + folderName);
        }
        String relativeName = fileName.substring(folderName.length());
        return relativeName;
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String filename;
        private Type type;

        public Entry() {
        }

        public Entry(String filename, Type type) {
            this.filename = filename;
            this.type = type;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            MODIFIED,
            NEW,
            DELETED;

        }
    }
}

