/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.plugins.findbugs.AbortException;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FindBugsCollector
implements FilePath.FileCallable<Void> {
    private static final boolean SKIP_OLD_FILES = false;
    private final transient BuildListener listener;
    private final FilePath workingDirectory;
    private final long buildTime;
    private final String filePattern;
    private static final long serialVersionUID = -6415863872891783891L;

    FindBugsCollector(BuildListener listener, FilePath workingDirectory, long buildTime, String filePattern) {
        this.listener = listener;
        this.workingDirectory = workingDirectory;
        this.buildTime = buildTime;
        this.filePattern = filePattern;
    }

    public Void invoke(File workspace, VirtualChannel channel) throws IOException {
        String[] findBugsFiles = this.findFindBugsFiles(workspace);
        if (findBugsFiles.length == 0) {
            throw new AbortException("No findbugs report files were found. Configuration error?");
        }
        int counter = 0;
        for (String file : findBugsFiles) {
            File originalFile = new File(workspace, file);
            try {
                new FilePath(originalFile).copyTo(this.workingDirectory.child("report-" + counter + ".xml"));
            }
            catch (InterruptedException exception) {
                throw new IOException2("Aborted while copying " + originalFile, (Throwable)exception);
            }
            ++counter;
        }
        return null;
    }

    private String[] findFindBugsFiles(File workspaceRoot) {
        FileSet fileSet = new FileSet();
        Project project = new Project();
        fileSet.setProject(project);
        fileSet.setDir(workspaceRoot);
        fileSet.setIncludes(this.filePattern);
        return fileSet.getDirectoryScanner(project).getIncludedFiles();
    }
}

