/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.plugins.findbugs.AbortException;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FindBugsCollector
implements FilePath.FileCallable<Void> {
    private static final String SLASH = "/";
    private static final long serialVersionUID = -6415863872891783891L;
    private static final boolean SKIP_OLD_FILES = false;
    private final transient BuildListener listener;
    private final FilePath workingDirectory;
    private final long buildTime;
    private final String filePattern;

    FindBugsCollector(BuildListener listener, FilePath workingDirectory, long buildTime, String filePattern) {
        this.listener = listener;
        this.workingDirectory = workingDirectory;
        this.buildTime = buildTime;
        this.filePattern = filePattern;
    }

    public Void invoke(File workspace, VirtualChannel channel) throws IOException {
        String[] findBugsFiles = this.findFindBugsFiles(workspace);
        if (findBugsFiles.length == 0) {
            throw new AbortException("No findbugs report files were found. Configuration error?");
        }
        int counter = 0;
        for (String file : findBugsFiles) {
            File originalFile = new File(workspace, file);
            try {
                String destinationName = StringUtils.defaultIfEmpty((String)this.guessModuleName(originalFile.getAbsolutePath()), (String)("report-" + counter)) + ".xml";
                new FilePath(originalFile).copyTo(this.workingDirectory.child(destinationName));
            }
            catch (InterruptedException exception) {
                throw new IOException2("Aborted while copying " + originalFile, (Throwable)exception);
            }
            ++counter;
        }
        return null;
    }

    public String guessModuleName(String fileName) {
        String separator = fileName.contains(SLASH) ? SLASH : "\\";
        String path = StringUtils.substringBefore((String)fileName, (String)(separator + "target"));
        if (fileName.equals(path)) {
            return "";
        }
        if (path.contains(separator)) {
            return StringUtils.substringAfterLast((String)path, (String)separator);
        }
        return path;
    }

    private String[] findFindBugsFiles(File workspaceRoot) {
        FileSet fileSet = new FileSet();
        Project project = new Project();
        fileSet.setProject(project);
        fileSet.setDir(workspaceRoot);
        fileSet.setIncludes(this.filePattern);
        return fileSet.getDirectoryScanner(project).getIncludedFiles();
    }
}

