/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.plugins.findbugs.JavaClass;
import hudson.plugins.findbugs.Warning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaPackage {
    private final List<JavaClass> classes = new ArrayList();
    private final String name;

    public JavaPackage(JavaClass javaClass) {
        this.name = javaClass.getPackage();
        this.addClass(javaClass);
    }

    public final void addClass(JavaClass javaClass) {
        this.classes.add(javaClass);
    }

    public final Collection<JavaClass> getClasses() {
        return Collections.unmodifiableCollection(this.classes);
    }

    public Collection<Warning> getWarnings() {
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        for (JavaClass javaClass : this.classes) {
            warnings.addAll(javaClass.getWarnings());
        }
        return warnings;
    }

    public final String getName() {
        return this.name;
    }

    public int getNumberOfWarnings() {
        int warnings = 0;
        for (JavaClass javaClass : this.classes) {
            warnings += javaClass.getNumberOfWarnings();
        }
        return warnings;
    }

    public int getNumberOfLowWarnings() {
        int warnings = 0;
        for (JavaClass javaClass : this.classes) {
            warnings += javaClass.getNumberOfLowWarnings();
        }
        return warnings;
    }

    public int getNumberOfHighWarnings() {
        int warnings = 0;
        for (JavaClass javaClass : this.classes) {
            warnings += javaClass.getNumberOfHighWarnings();
        }
        return warnings;
    }

    public int getNumberOfNormalWarnings() {
        int warnings = 0;
        for (JavaClass javaClass : this.classes) {
            warnings += javaClass.getNumberOfNormalWarnings();
        }
        return warnings;
    }
}

