/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.plugins.findbugs.JavaClass;
import hudson.plugins.findbugs.JavaPackage;
import hudson.plugins.findbugs.Warning;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module {
    private final Map<String, JavaPackage> packages = new HashMap();
    private String version;
    private String threshold;
    private String effort;
    private String name;

    public void addClass(JavaClass javaClass) {
        String packageName = javaClass.getPackage();
        if (this.packages.containsKey(packageName)) {
            ((JavaPackage)this.packages.get(packageName)).addClass(javaClass);
        } else {
            this.packages.put(packageName, new JavaPackage(javaClass));
        }
    }

    public Collection<JavaPackage> getPackages() {
        return Collections.unmodifiableCollection(this.packages.values());
    }

    public int getNumberOfWarnings() {
        int warnings = 0;
        for (JavaPackage javaPackage : this.packages.values()) {
            warnings += javaPackage.getNumberOfWarnings();
        }
        return warnings;
    }

    public Collection<Warning> getWarnings(String packageName) {
        if (this.packages.containsKey(packageName)) {
            return ((JavaPackage)this.packages.get(packageName)).getWarnings();
        }
        return Collections.emptyList();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public void setThreshold(String threshold) {
        this.threshold = threshold;
    }

    public String getEffort() {
        return this.effort;
    }

    public void setEffort(String effort) {
        this.effort = effort;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNumberOfWarnings(String packageName) {
        if (this.packages.containsKey(packageName)) {
            return ((JavaPackage)this.packages.get(packageName)).getNumberOfWarnings();
        }
        return 0;
    }
}

