/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.plugins.findbugs.Warning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClass {
    private final List<Warning> warnings = new ArrayList<Warning>();
    private int low;
    private int high;
    private int normal;
    private String classname;

    public void addWarning(Warning warning) {
        this.warnings.add(warning);
        warning.setClassname(StringUtils.substringAfterLast((String)this.classname, (String)"."));
        if ("low".equalsIgnoreCase(warning.getPriority())) {
            ++this.low;
        } else if ("high".equalsIgnoreCase(warning.getPriority())) {
            ++this.high;
        } else {
            ++this.normal;
        }
    }

    public Collection<Warning> getWarnings() {
        return Collections.unmodifiableCollection(this.warnings);
    }

    public int getNumberOfWarnings() {
        return this.warnings.size();
    }

    public int getNumberOfLowWarnings() {
        return this.low;
    }

    public int getNumberOfHighWarnings() {
        return this.high;
    }

    public int getNumberOfNormalWarnings() {
        return this.normal;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getPackage() {
        return StringUtils.substringBeforeLast((String)this.classname, (String)".");
    }
}

