/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.plugins.findbugs.Module;
import hudson.plugins.findbugs.Warning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProject {
    private final List<Module> modules = new ArrayList<Module>();

    public final void addModule(Module module) {
        this.modules.add(module);
    }

    public Collection<Module> getModules() {
        return Collections.unmodifiableCollection(this.modules);
    }

    public int getNumberOfWarnings() {
        int warnings = 0;
        for (Module module : this.modules) {
            warnings += module.getNumberOfWarnings();
        }
        return warnings;
    }

    public int getNumberOfWarnings(String packageName) {
        int warnings = 0;
        for (Module module : this.modules) {
            warnings += module.getNumberOfWarnings(packageName);
        }
        return warnings;
    }

    public Collection<Warning> getWarnings(String packageName) {
        ArrayList<Warning> warnings = new ArrayList<Warning>();
        for (Module module : this.modules) {
            warnings.addAll(module.getWarnings(packageName));
        }
        return warnings;
    }
}

