/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import hudson.plugins.findbugs.parser.Bug;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import hudson.plugins.findbugs.util.model.LineRange;
import hudson.plugins.findbugs.util.model.MavenModule;
import hudson.plugins.findbugs.util.model.Priority;
import hudson.remoting.Which;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;

/*
 * Exception performing whole class analysis ignored.
 */
public class NativeFindBugsParser {
    private static boolean isLibraryInitialized;

    public MavenModule parse(InputStream file, String moduleRoot, String moduleName) throws IOException, DocumentException {
        Project project = this.createMavenProject(moduleRoot);
        SortedBugCollection collection = new SortedBugCollection();
        collection.readXML(file, project);
        SourceFinder sourceFinder = new SourceFinder();
        sourceFinder.setSourceBaseList(project.getSourceDirList());
        String actualName = this.extractModuleName(moduleName, project);
        MavenModule module = new MavenModule(actualName);
        Collection bugs = collection.getCollection();
        for (BugInstance warning : bugs) {
            String fileName;
            SourceLineAnnotation sourceLine = warning.getPrimarySourceLineAnnotation();
            Bug bug = new Bug(this.getPriority(warning), this.getMessage(warning), this.getCategory(warning), warning.getType(), sourceLine.getStartLine(), sourceLine.getEndLine());
            Iterator annotationIterator = warning.annotationIterator();
            while (annotationIterator.hasNext()) {
                BugAnnotation bugAnnotation = (BugAnnotation)annotationIterator.next();
                if (!(bugAnnotation instanceof SourceLineAnnotation)) continue;
                SourceLineAnnotation annotation = (SourceLineAnnotation)bugAnnotation;
                bug.addLineRange(new LineRange(annotation.getStartLine(), annotation.getEndLine()));
            }
            try {
                SourceFile sourceFile = sourceFinder.findSourceFile(sourceLine);
                fileName = sourceFile.getFullFileName();
            }
            catch (IOException exception) {
                fileName = sourceLine.getPackageName().replace(".", "/") + "/" + sourceLine.getSourceFile();
            }
            bug.setFileName(fileName);
            bug.setPackageName(warning.getPrimaryClass().getPackageName());
            bug.setModuleName(actualName);
            module.addAnnotation((FileAnnotation)bug);
        }
        return module;
    }

    private String getMessage(BugInstance warning) {
        if (this.useNativeLibrary()) {
            return warning.getMessage();
        }
        return "";
    }

    private boolean useNativeLibrary() {
        return isLibraryInitialized;
    }

    private Priority getPriority(BugInstance warning) {
        switch (warning.getPriority()) {
            case 1: {
                return Priority.HIGH;
            }
            case 2: {
                return Priority.NORMAL;
            }
        }
        return Priority.LOW;
    }

    private String extractModuleName(String defaultName, Project project) {
        if (StringUtils.isBlank((String)project.getProjectName())) {
            return defaultName;
        }
        return project.getProjectName();
    }

    private String getCategory(BugInstance warning) {
        if (this.useNativeLibrary()) {
            BugPattern bugPattern = warning.getBugPattern();
            if (bugPattern == null) {
                return "Unknown";
            }
            return bugPattern.getCategory();
        }
        return "";
    }

    private static void initializeFindBugs() {
        try {
            File findBugsJar = Which.jarFile(DetectorFactoryCollection.class);
            String path = findBugsJar.getCanonicalPath();
            File core = new File(path.replace("findbugs-", "coreplugin-").replace("findbugs/findbugs", "findbugs/coreplugin").replace("findbugs\\findbugs", "findbugs\\coreplugin"));
            DetectorFactoryCollection.rawInstance().setPluginList(new URL[]{core.toURL()});
            isLibraryInitialized = true;
        }
        catch (Exception exception) {
            isLibraryInitialized = false;
        }
    }

    private Project createMavenProject(String moduleRoot) {
        Project project = new Project();
        project.addSourceDir(moduleRoot + "/src/main/java");
        project.addSourceDir(moduleRoot + "/src/test/java");
        project.addSourceDir(moduleRoot + "/src");
        return project;
    }

    static {
        NativeFindBugsParser.initializeFindBugs();
    }
}

