/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.Messages;

public final class ResultSummary {
    public static String createSummary(FindBugsResult result) {
        StringBuilder summary = new StringBuilder();
        int bugs = result.getNumberOfAnnotations();
        summary.append("FindBugs: ");
        if (bugs > 0) {
            summary.append("<a href=\"findbugsResult\">");
        }
        if (bugs == 1) {
            summary.append(Messages._FindBugs_ResultAction_OneWarning());
        } else {
            summary.append(Messages._FindBugs_ResultAction_MultipleWarnings(bugs));
        }
        if (bugs > 0) {
            summary.append("</a>");
        }
        summary.append(" ");
        if (result.getNumberOfModules() > 1) {
            summary.append(Messages._FindBugs_ResultAction_MultipleFiles(result.getNumberOfModules()));
        } else {
            summary.append(Messages._FindBugs_ResultAction_OneFile());
        }
        return summary.toString();
    }

    public static String createDeltaMessage(FindBugsResult result) {
        StringBuilder summary = new StringBuilder();
        if (result.getNumberOfNewWarnings() > 0) {
            summary.append("<li><a href=\"findbugsResult/new\">");
            if (result.getNumberOfNewWarnings() == 1) {
                summary.append(Messages._FindBugs_ResultAction_OneNewWarning());
            } else {
                summary.append(Messages._FindBugs_ResultAction_MultipleNewWarnings(result.getNumberOfNewWarnings()));
            }
            summary.append("</a></li>");
        }
        if (result.getNumberOfFixedWarnings() > 0) {
            summary.append("<li><a href=\"findbugsResult/fixed\">");
            if (result.getNumberOfFixedWarnings() == 1) {
                summary.append(Messages._FindBugs_ResultAction_OneFixedWarning());
            } else {
                summary.append(Messages._FindBugs_ResultAction_MultipleFixedWarnings(result.getNumberOfFixedWarnings()));
            }
            summary.append("</a></li>");
        }
        return summary.toString();
    }

    private ResultSummary() {
    }
}

