/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.findbugs.util.AbortException;
import hudson.plugins.findbugs.util.HealthReportBuilder;
import hudson.plugins.findbugs.util.ParserResult;
import hudson.plugins.findbugs.util.TrendReportSize;
import hudson.tasks.Ant;
import hudson.tasks.Builder;
import hudson.tasks.Maven;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HealthAwarePublisher
extends Publisher {
    private final String threshold;
    private boolean thresholdEnabled;
    private int minimumAnnotations;
    private final String healthy;
    private final String unHealthy;
    private int healthyAnnotations;
    private int unHealthyAnnotations;
    private boolean healthyReportEnabled;
    private final String height;
    private final String pluginName;

    public HealthAwarePublisher(String threshold, String healthy, String unHealthy, String height, String pluginName) {
        this.threshold = threshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.height = height;
        this.pluginName = "[" + pluginName + "] ";
        if (!StringUtils.isEmpty((String)threshold)) {
            try {
                this.minimumAnnotations = Integer.valueOf(threshold);
                if (this.minimumAnnotations >= 0) {
                    this.thresholdEnabled = true;
                }
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)healthy) && !StringUtils.isEmpty((String)unHealthy)) {
            try {
                this.healthyAnnotations = Integer.valueOf(healthy);
                this.unHealthyAnnotations = Integer.valueOf(unHealthy);
                if (this.healthyAnnotations >= 0 && this.unHealthyAnnotations > this.healthyAnnotations) {
                    this.healthyReportEnabled = true;
                }
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
    }

    public final boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.canContinue(build.getResult())) {
            PrintStream logger = listener.getLogger();
            try {
                ParserResult project = this.perform(build, logger);
                this.evaluateBuildResult(build, logger, project);
            }
            catch (AbortException exception) {
                logger.println(exception.getMessage());
                build.setResult(Result.FAILURE);
                return false;
            }
        }
        return true;
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    protected abstract ParserResult perform(AbstractBuild<?, ?> var1, PrintStream var2) throws InterruptedException, IOException;

    private void evaluateBuildResult(AbstractBuild<?, ?> build, PrintStream logger, ParserResult project) {
        int annotationCount = project.getNumberOfAnnotations();
        if (annotationCount > 0) {
            this.log(logger, "A total of " + annotationCount + " annotations have been found.");
            if (this.isThresholdEnabled() && annotationCount >= this.getMinimumAnnotations()) {
                build.setResult(Result.UNSTABLE);
            }
        } else {
            this.log(logger, "No annotations have been found.");
        }
    }

    protected void log(PrintStream logger, String message) {
        logger.println(StringUtils.defaultString((String)this.pluginName) + message);
    }

    protected HealthReportBuilder createHealthReporter(String reportSingleCount, String reportMultipleCount) {
        return new HealthReportBuilder(this.thresholdEnabled, this.minimumAnnotations, this.healthyReportEnabled, this.healthyAnnotations, this.unHealthyAnnotations, reportSingleCount, reportMultipleCount);
    }

    public boolean isThresholdEnabled() {
        return this.thresholdEnabled;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public int getMinimumAnnotations() {
        return this.minimumAnnotations;
    }

    public boolean isHealthyReportEnabled() {
        return this.healthyReportEnabled;
    }

    public String getHealthy() {
        return this.healthy;
    }

    public int getHealthyAnnotations() {
        return this.healthyAnnotations;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public int getUnHealthyAnnotations() {
        return this.unHealthyAnnotations;
    }

    public String getHeight() {
        return this.height;
    }

    public int getTrendHeight() {
        return new TrendReportSize(this.height).getHeight();
    }

    protected boolean isMavenBuild(AbstractBuild<?, ?> build) {
        if (build.getProject() instanceof Project) {
            Project project = (Project)build.getProject();
            for (Builder builder : project.getBuilders()) {
                if (!(builder instanceof Maven)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isAntBuild(AbstractBuild<?, ?> build) {
        if (build.getProject() instanceof Project) {
            Project project = (Project)build.getProject();
            for (Builder builder : project.getBuilders()) {
                if (!(builder instanceof Ant)) continue;
                return true;
            }
        }
        return false;
    }
}

