/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser;

import hudson.FilePath;
import hudson.plugins.findbugs.parser.NativeFindBugsParser;
import hudson.plugins.findbugs.parser.PlainFindBugsParser;
import hudson.plugins.findbugs.parser.maven.MavenFindBugsParser;
import hudson.plugins.findbugs.util.AnnotationParser;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsParser
implements AnnotationParser {
    private static final long serialVersionUID = 8306319007761954027L;
    private final FilePath workspace;
    private final boolean autoInitializeFindBugs;

    public FindBugsParser(FilePath workspace, boolean autoInitializeFindBugs) {
        this.workspace = workspace;
        this.autoInitializeFindBugs = autoInitializeFindBugs;
    }

    public FindBugsParser(FilePath workspace, boolean autoInitializeFindBugs, List<String> sourceFolders) {
        this.workspace = workspace;
        this.autoInitializeFindBugs = autoInitializeFindBugs;
    }

    public String getName() {
        return "FINDBUGS";
    }

    public Collection<FileAnnotation> parse(File file, String moduleName) throws InvocationTargetException {
        try {
            MavenFindBugsParser mavenFindBugsParser = new MavenFindBugsParser();
            if (mavenFindBugsParser.accepts((InputStream)new FileInputStream(file))) {
                return mavenFindBugsParser.parse((InputStream)new FileInputStream(file), moduleName, this.workspace);
            }
            Object parser = this.autoInitializeFindBugs ? new NativeFindBugsParser() : new PlainFindBugsParser();
            String moduleRoot = StringUtils.substringBefore((String)file.getAbsolutePath().replace('\\', '/'), (String)"/target/");
            return parser.parse((InputStream)new FileInputStream(file), moduleRoot, moduleName);
        }
        catch (IOException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SAXException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (DocumentException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public Collection<FileAnnotation> parse(InputStream file, String moduleName) throws InvocationTargetException {
        throw new UnsupportedOperationException("FinBugs parser does not parse input streams.");
    }
}

