/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser;

import com.mebigfatguy.fbcontrib.FBContrib;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.detect.DroppedException;
import hudson.plugins.findbugs.parser.Bug;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import hudson.plugins.findbugs.util.model.LineRange;
import hudson.plugins.findbugs.util.model.Priority;
import hudson.remoting.Which;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class PlainFindBugsParser {
    public Collection<FileAnnotation> parse(InputStream file, String moduleRoot, String moduleName) throws IOException, DocumentException {
        Project project = this.createMavenProject(moduleRoot);
        SortedBugCollection collection = new SortedBugCollection();
        collection.readXML(file, project);
        SourceFinder sourceFinder = new SourceFinder();
        sourceFinder.setSourceBaseList(project.getSourceDirList());
        String actualName = this.extractModuleName(moduleName, project);
        ArrayList<FileAnnotation> annotations = new ArrayList<FileAnnotation>();
        Collection bugs = collection.getCollection();
        for (BugInstance warning : bugs) {
            String fileName;
            SourceLineAnnotation sourceLine = warning.getPrimarySourceLineAnnotation();
            Bug bug = new Bug(this.getPriority(warning), this.getMessage(warning), warning.getBugPattern().getCategory(), warning.getType(), sourceLine.getStartLine(), sourceLine.getEndLine(), warning.getBugPattern().getDetailText());
            Iterator annotationIterator = warning.annotationIterator();
            while (annotationIterator.hasNext()) {
                BugAnnotation bugAnnotation = (BugAnnotation)annotationIterator.next();
                if (!(bugAnnotation instanceof SourceLineAnnotation)) continue;
                SourceLineAnnotation annotation = (SourceLineAnnotation)bugAnnotation;
                bug.addLineRange(new LineRange(annotation.getStartLine(), annotation.getEndLine()));
            }
            try {
                SourceFile sourceFile = sourceFinder.findSourceFile(sourceLine);
                fileName = sourceFile.getFullFileName();
            }
            catch (IOException exception) {
                fileName = sourceLine.getPackageName().replace(".", "/") + "/" + sourceLine.getSourceFile();
            }
            bug.setFileName(fileName);
            bug.setPackageName(warning.getPrimaryClass().getPackageName());
            bug.setModuleName(actualName);
            annotations.add((FileAnnotation)bug);
        }
        return annotations;
    }

    private String getMessage(BugInstance warning) {
        return warning.getMessage();
    }

    private Priority getPriority(BugInstance warning) {
        switch (warning.getPriority()) {
            case 1: {
                return Priority.HIGH;
            }
            case 2: {
                return Priority.NORMAL;
            }
        }
        return Priority.LOW;
    }

    private String extractModuleName(String defaultName, Project project) {
        if (StringUtils.isBlank((String)project.getProjectName())) {
            return defaultName;
        }
        return project.getProjectName();
    }

    public static URL[] createPluginUrls() throws MalformedURLException {
        return new URL[]{PlainFindBugsParser.getPluginPath(DroppedException.class), PlainFindBugsParser.getPluginPath(FBContrib.class)};
    }

    @SuppressWarnings(value={"REC"})
    private static URL getPluginPath(Class<?> clazz) throws MalformedURLException {
        try {
            return Which.jarFile(clazz).toURL();
        }
        catch (Exception exception) {
            return new URL("file://");
        }
    }

    private Project createMavenProject(String moduleRoot) {
        Project project = new Project();
        project.addSourceDir(moduleRoot + "/src/main/java");
        project.addSourceDir(moduleRoot + "/src/test/java");
        project.addSourceDir(moduleRoot + "/src");
        return project;
    }
}

